/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusStyleClipboard;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.PasteStyleCommandProvider;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.ISimpleAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;

public class PasteStylePureGraphicalAction
extends Action
implements IDisposableAction {
    private boolean isDisposed = true;
    private Optional<TransactionalEditingDomain> editingDomainOpt = Optional.empty();
    private Optional<IPropertyChangeListener> changeListenerOpt = Optional.empty();
    private ISelectionListener onChangeSelection = (part, selection) -> EclipseUIUtil.displaySyncExec(() -> this.updateActionState(this.getTargetEditParts(selection)));
    private ISimpleAuthorityListener onChangePermission = () -> EclipseUIUtil.displaySyncExec(() -> this.updateActionState(this.getTargetEditParts()));
    private SiriusStyleClipboard.Listener onChangeClipboard = (gmfView, siriusStyle) -> EclipseUIUtil.displaySyncExec(() -> this.updateActionState(this.getTargetEditParts()));

    public PasteStylePureGraphicalAction() {
        this.setId("pasteStylePureGraphicalAction");
        this.setText(Messages.PasteStylePureGraphicalAction_text);
        this.setToolTipText(Messages.PasteStylePureGraphicalAction_toolTipText);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteStyle.gif"));
    }

    public void init() {
        if (this.isDisposed) {
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page != null) {
                page.addSelectionListener(this.onChangeSelection);
            }
            this.updateActionState(this.getTargetEditParts());
            SiriusStyleClipboard.getInstance().addListener(this.onChangeClipboard);
            this.changeListenerOpt.ifPresent(changeListener -> this.addPropertyChangeListener((IPropertyChangeListener)changeListener));
            this.isDisposed = false;
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.editingDomainOpt.ifPresent(editingDomain -> {
                IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editingDomain.getResourceSet());
                permissionAuthoriry.removeAuthorityListener((IAuthorityListener)this.onChangePermission);
            });
            this.changeListenerOpt.ifPresent(changeListener -> this.removePropertyChangeListener((IPropertyChangeListener)changeListener));
            SiriusStyleClipboard.getInstance().removeListener(this.onChangeClipboard);
            this.onChangePermission = null;
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page != null) {
                page.removeSelectionListener(this.onChangeSelection);
                this.onChangeSelection = null;
            }
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private String getCommandLabel() {
        return Messages.PasteStylePureGraphicalAction_commandLabel;
    }

    private boolean canEditElement(DDiagramElement dDiagramElement) {
        Resource resource = dDiagramElement.eResource();
        if (resource == null) {
            return false;
        }
        IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resource.getResourceSet());
        return permissionAuthoriry.canEditInstance((EObject)dDiagramElement.getParentDiagram());
    }

    private void updatePermissionListener(Optional<TransactionalEditingDomain> newEditingDomainOpt) {
        this.editingDomainOpt.ifPresent(editingDomain -> {
            IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editingDomain.getResourceSet());
            permissionAuthoriry.removeAuthorityListener((IAuthorityListener)this.onChangePermission);
        });
        this.editingDomainOpt = newEditingDomainOpt;
        this.editingDomainOpt.ifPresent(editingDomain -> {
            IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editingDomain.getResourceSet());
            permissionAuthoriry.addAuthorityListener((IAuthorityListener)this.onChangePermission);
        });
    }

    private void updateActionState(List<IGraphicalEditPart> targetEditParts) {
        Optional<TransactionalEditingDomain> newEditingDomainOpt = this.getEditingDomain(targetEditParts);
        SiriusStyleClipboard clipboard = SiriusStyleClipboard.getInstance();
        this.updatePermissionListener(newEditingDomainOpt);
        boolean haveDomain = newEditingDomainOpt.isPresent();
        boolean haveClipboard = clipboard.getGmfView().isPresent() || clipboard.getSiriusStyle().isPresent();
        boolean haveEditableSelection = targetEditParts.stream().map(IGraphicalEditPart::resolveSemanticElement).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).anyMatch(this::canEditElement);
        this.setEnabled(haveDomain && haveClipboard && haveEditableSelection);
    }

    public void onChangeState(Optional<IPropertyChangeListener> listener) {
        if (!this.isDisposed()) {
            throw new IllegalStateException("onChangeState must be called before action is initialized");
        }
        this.changeListenerOpt = listener;
    }

    private Object getTargetEditPart(Object selection) {
        if (selection instanceof LabelEditPart) {
            LabelEditPart editPart = (LabelEditPart)selection;
            return editPart.getParent();
        }
        return selection;
    }

    private List<IGraphicalEditPart> getTargetEditParts() {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            return this.getTargetEditParts(page.getSelection());
        }
        return List.of();
    }

    private List<IGraphicalEditPart> getTargetEditParts(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Spliterator selectionIterator = structuredSelection.spliterator();
            return StreamSupport.stream(selectionIterator, false).map(this::getTargetEditPart).filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).toList();
        }
        return List.of();
    }

    private Optional<TransactionalEditingDomain> getEditingDomain(List<IGraphicalEditPart> targetEditParts) {
        return targetEditParts.stream().map(editPart -> editPart.getEditingDomain()).filter(Objects::nonNull).findAny();
    }

    public void run() {
        List<IGraphicalEditPart> targetEditParts = this.getTargetEditParts();
        SiriusStyleClipboard clipboard = SiriusStyleClipboard.getInstance();
        this.getEditingDomain(targetEditParts).ifPresent(domain -> {
            final CompoundCommand command = new CompoundCommand();
            command.setDebugLabel(Messages.SiriusPropertyHandlerEditPolicy_chainedStyleCommandDebugLabel);
            for (IGraphicalEditPart targetEditPart : targetEditParts) {
                DDiagramElement targetElement;
                EObject eObject = targetEditPart.resolveSemanticElement();
                if (!(eObject instanceof DDiagramElement) || !this.canEditElement(targetElement = (DDiagramElement)eObject)) continue;
                clipboard.getSiriusStyle().ifPresent(siriusStyle -> clipboard.getGmfView().ifPresent(gmfView -> {
                    if (!(siriusStyle instanceof EdgeStyle) || targetElement instanceof DEdge) {
                        command.add(PasteStyleCommandProvider.createGMFCommand(domain, targetEditPart, gmfView));
                        command.add(PasteStyleCommandProvider.createSiriusCommand(domain, (DSemanticDecorator)targetElement, siriusStyle));
                    }
                }));
            }
            if (!command.isEmpty()) {
                domain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)domain, this.getCommandLabel()){

                    protected void doExecute() {
                        command.execute();
                    }
                });
            }
        });
    }
}

