/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.ILaunchConfigurationProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public abstract class AbstractLaunchConfigProvider
implements ILaunchConfigurationProvider {
    private static final String ATTR_ORIGINAL_NAME = "org.eclipse.launchbar.core.originalName";
    private static final String ATTR_PROVIDER_CLASS = "org.eclipse.launchbar.core.providerClass";

    protected ILaunchConfiguration createLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        String name = launchManager.generateLaunchConfigurationName(descriptor.getName());
        ILaunchConfigurationType type = this.getLaunchConfigurationType(descriptor, target);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        this.populateLaunchConfiguration(descriptor, target, workingCopy);
        return workingCopy.doSave();
    }

    protected void updateLaunchConfiguration(ILaunchConfiguration config, ILaunchTarget target) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        if (workingCopy.isDirty()) {
            workingCopy.doSave();
        }
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        workingCopy.setAttribute(ATTR_ORIGINAL_NAME, workingCopy.getName());
        workingCopy.setAttribute(ATTR_PROVIDER_CLASS, this.getClass().getName());
    }

    @Override
    public boolean launchDescriptorMatches(ILaunchDescriptor descriptor, ILaunchConfiguration configuration, ILaunchTarget target) throws CoreException {
        ILaunchConfiguration lc = (ILaunchConfiguration)descriptor.getAdapter(ILaunchConfiguration.class);
        if (lc == null) {
            return false;
        }
        return configuration.getName().equals(lc.getName());
    }

    protected boolean ownsLaunchConfiguration(ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.exists()) {
            return false;
        }
        if (configuration.getAttribute(ATTR_PROVIDER_CLASS, "").equals(this.getClass().getName())) {
            String origName = configuration.getAttribute(ATTR_ORIGINAL_NAME, "");
            return origName.equals(configuration.getName()) || !DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(origName);
        }
        return false;
    }
}

