/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.Accessor;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.TypeName;
import org.eclipse.jpt.jaxb.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.FieldAccessor;
import org.eclipse.jpt.jaxb.core.internal.context.java.JavaTypeName;
import org.eclipse.jpt.jaxb.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaPersistentAttribute
extends AbstractJavaContextNode
implements JavaPersistentAttribute {
    protected final Accessor accessor;
    protected JavaAttributeMapping mapping;
    protected String defaultMappingKey;

    public static JavaPersistentAttribute buildPersistentProperty(JaxbClassMapping parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return new GenericJavaPersistentAttribute(parent, new PropertyAccessor(parent, resourceGetter, resourceSetter));
    }

    public static JavaPersistentAttribute buildPersistentField(JaxbClassMapping parent, JavaResourceField resourceField) {
        return new GenericJavaPersistentAttribute(parent, new FieldAccessor(parent, resourceField));
    }

    public GenericJavaPersistentAttribute(JaxbClassMapping parent, Accessor accessor) {
        super(parent);
        this.accessor = accessor;
        this.mapping = this.buildMapping();
    }

    @Override
    public JavaClassMapping getClassMapping() {
        return (JavaClassMapping)super.getParent();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncMapping();
    }

    @Override
    public void update() {
        super.update();
        this.updateMapping();
    }

    @Override
    public TypeName getDeclaringTypeName() {
        return new JavaTypeName((JavaResourceAbstractType)this.getDeclaringJavaResourceType());
    }

    public JavaResourceType getDeclaringJavaResourceType() {
        return this.accessor.getJavaResourceAttribute().getResourceType();
    }

    @Override
    public boolean isInherited() {
        return ObjectTools.notEquals((Object)this.getDeclaringTypeName(), (Object)this.getClassMapping().getTypeName());
    }

    @Override
    public String getName() {
        return this.getJavaResourceAttribute().getName();
    }

    @Override
    public boolean isFor(JavaResourceField resourceField) {
        return this.accessor.isFor(resourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.accessor.isFor(resourceGetter, resourceSetter);
    }

    @Override
    public JavaResourceAttribute getJavaResourceAttribute() {
        return this.accessor.getJavaResourceAttribute();
    }

    @Override
    public String getJavaResourceAttributeBaseTypeName() {
        return this.accessor.getJavaResourceAttributeBaseTypeName();
    }

    @Override
    public boolean isJavaResourceAttributeCollectionType() {
        return this.accessor.isJavaResourceAttributeCollectionType();
    }

    @Override
    public boolean isJavaResourceAttributeTypeSubTypeOf(String typeName) {
        return this.accessor.isJavaResourceAttributeTypeSubTypeOf(typeName);
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(JavaAttributeMapping mapping) {
        JavaAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public JaxbAttributeMapping setMappingKey(String key) {
        if (this.mapping.isDefault()) {
            if (key != null) {
                this.setMappingKey_(key);
            }
        } else if (!ObjectTools.equals((Object)key, (Object)this.mapping.getKey())) {
            this.setMappingKey_(key);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String key) {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition(key);
        if (definition == null) {
            definition = this.getDefaultMappingDefinition();
            Iterable<String> supportingAnnotationNames = definition != null ? definition.getSupportingAnnotationNames() : EmptyIterable.instance();
            this.setMappingAnnotation(null, supportingAnnotationNames);
        } else {
            this.setMappingAnnotation(definition);
        }
        this.setMapping(this.buildMapping(definition));
    }

    protected void setMappingAnnotation(JavaAttributeMappingDefinition definition) {
        this.setMappingAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
    }

    protected void setMappingAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        this.getJavaResourceAttribute().setPrimaryAnnotation(primaryAnnotationName, supportingAnnotationNames);
    }

    protected JavaAttributeMapping buildMapping(JavaAttributeMappingDefinition definition) {
        return definition == null ? this.buildNullMapping() : this.buildMapping_(definition);
    }

    protected JavaAttributeMapping buildNullMapping() {
        return this.getFactory().buildJavaNullAttributeMapping(this);
    }

    protected JavaAttributeMapping buildMapping_(JavaAttributeMappingDefinition definition) {
        if (this.mapping != null && this.mapping.isDefault() && ObjectTools.equals((Object)this.mapping.getKey(), (Object)definition.getKey())) {
            this.mapping.synchronizeWithResourceModel();
            return this.mapping;
        }
        return definition.buildMapping(this, this.getFactory());
    }

    protected JavaAttributeMapping buildMapping() {
        return this.buildMapping(this.getSpecifiedMappingDefinition());
    }

    protected void syncMapping() {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition();
        if (definition == null) {
            if (this.mapping.isDefault()) {
                this.mapping.synchronizeWithResourceModel();
            } else {
                definition = this.getDefaultMappingDefinition();
                this.setMapping(this.buildMapping(definition));
            }
        } else if (this.mapping.isDefault()) {
            this.setMapping(this.buildMapping(definition));
        } else if (ObjectTools.equals((Object)definition.getKey(), (Object)this.mapping.getKey())) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(definition));
        }
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition(String key) {
        if (key == null) {
            return null;
        }
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!ObjectTools.equals((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("invalid mapping key: " + key);
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition() {
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!definition.isSpecified(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<JavaAttributeMappingDefinition> getSpecifiedMappingDefinitions() {
        return this.getPlatform().getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMappingKey;
    }

    protected void setDefaultMappingKey(String mappingKey) {
        String old = this.defaultMappingKey;
        this.defaultMappingKey = mappingKey;
        this.firePropertyChanged("defaultMappingKey", old, mappingKey);
    }

    protected void updateMapping() {
        String newDefaultKey;
        JavaAttributeMappingDefinition definition = this.getDefaultMappingDefinition();
        String string = newDefaultKey = definition == null ? null : definition.getKey();
        if (this.mapping.isDefault() && ObjectTools.notEquals((Object)this.mapping.getKey(), (Object)newDefaultKey)) {
            this.setMapping(this.buildMapping(definition));
        } else {
            this.mapping.update();
        }
        this.setDefaultMappingKey(newDefaultKey);
    }

    protected JavaAttributeMappingDefinition getDefaultMappingDefinition() {
        for (DefaultJavaAttributeMappingDefinition definition : this.getDefaultMappingDefinitions()) {
            if (!definition.isDefault(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<DefaultJavaAttributeMappingDefinition> getDefaultMappingDefinitions() {
        return this.getPlatform().getDefaultJavaAttributeMappingDefinitions();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.mapping.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJavaResourceAttribute().getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        JavaAttributeMappingDefinition currentMappingDefinition = this.getCurrentMappingDefinition();
        Iterable<String> supportingAnnotationNames = currentMappingDefinition.getSupportingAnnotationNames();
        for (Annotation annotation : this.getJavaResourceAttribute().getTopLevelAnnotations()) {
            if (!ObjectTools.notEquals((Object)currentMappingDefinition.getAnnotationName(), (Object)annotation.getAnnotationName()) || IterableTools.contains(supportingAnnotationNames, (Object)annotation.getAnnotationName())) continue;
            messages.add(this.buildValidationMessage(annotation.getTextRange(), JptJaxbCoreValidationMessages.ATTRIBUTE_MAPPING__UNSUPPORTED_ANNOTATION, annotation.getAnnotationName(), currentMappingDefinition.getAnnotationName()));
        }
        this.getMapping().validate(messages, reporter);
    }

    protected JavaAttributeMappingDefinition getCurrentMappingDefinition() {
        Iterable<JavaAttributeMappingDefinition> mappingDefinitions = this.mapping.isDefault() ? this.getDefaultMappingDefinitions() : this.getSpecifiedMappingDefinitions();
        for (JavaAttributeMappingDefinition mappingDefinition : mappingDefinitions) {
            if (!ObjectTools.equals((Object)mappingDefinition.getKey(), (Object)this.mapping.getKey())) continue;
            return mappingDefinition;
        }
        return null;
    }
}

