/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.MoveProjectAction;

public class ReorgMoveAction
extends SelectionDispatchAction {
    public ReorgMoveAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.ReorgMoveAction_3);
        this.setDescription(ReorgMessages.ReorgMoveAction_4);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        block7: {
            if (!selection.isEmpty()) {
                if (ReorgUtils.containsOnlyProjects(selection.toList())) {
                    this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
                    return;
                }
                try {
                    List elements = selection.toList();
                    IResource[] resources = ReorgUtils.getResources(elements);
                    IModelElement[] modelElements = ReorgUtils.getModelElements(elements);
                    if (elements.size() != resources.length + modelElements.length) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(resources, modelElements));
                }
                catch (ModelException e) {
                    if (ScriptModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                        DLTKUIPlugin.log(e);
                    }
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(ModelTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveAvailable(selection));
        }
        catch (ModelException e) {
            this.setEnabled(false);
        }
    }

    private MoveProjectAction createWorkbenchAction(IStructuredSelection selection) {
        MoveProjectAction action = new MoveProjectAction((IShellProvider)this.getSite());
        action.selectionChanged(selection);
        return action;
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        try {
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IModelElement[] modelElements = ReorgUtils.getModelElements(elements);
            if (RefactoringAvailabilityTester.isMoveAvailable(resources, modelElements)) {
                RefactoringExecutionStarter.startRefactoring(resources, modelElements, this.getShell());
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

