/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.RefreshEditModelJob;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;

public class SQLExecutionJobListener
implements IJobChangeListener {
    private ISchemaObjectEditor _editor;
    private IProgressMonitor _monitor;

    public SQLExecutionJobListener(ISchemaObjectEditor editor, IProgressMonitor monitor) {
        this._editor = editor;
        this._monitor = monitor;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        if (this._editor == null) {
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SQLExecutionJobListener.this._monitor != null) {
                        SQLExecutionJobListener.this._monitor.setCanceled(true);
                    }
                }
            });
            return;
        }
        if (event.getResult().isOK()) {
            ISchemaObjectEditorHandler handler;
            final ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this._editor.getEditorInput();
            input.getEditModelObject().stopLogging();
            IEditorPart part = SOEUIPlugin.getActiveWorkbenchPage().findEditor(this._editor.getEditorInput());
            if (part != null) {
                SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SQLExecutionJobListener.this._editor.setEditorPartName(input.getEditModelObject().getMainSQLObject().getName());
                    }
                });
            }
            if ((handler = this._editor.getEditorHandler()) != null && this._editor.needRefreshAfterSave()) {
                RefreshEditModelJob refreshJob = new RefreshEditModelJob(Messages.SQLExecutionJobListener_refreshing, handler);
                refreshJob.setUser(true);
                refreshJob.schedule();
                refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        super.done(event);
                        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (SQLExecutionJobListener.this._monitor != null) {
                                    SQLExecutionJobListener.this._monitor.done();
                                }
                            }
                        });
                    }
                });
            }
        } else {
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String[] buttons = new String[]{IDialogConstants.YES_LABEL};
                    MessageDialog d = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.SavePreviewDialog_problem, null, Messages.SavePreviewDialog_execution_failed_msg, 1, buttons, 0);
                    d.open();
                    if (SQLExecutionJobListener.this._monitor != null) {
                        SQLExecutionJobListener.this._monitor.setCanceled(true);
                    }
                }
            });
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

