/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.burningwave.core.Component;
import org.burningwave.core.function.Executor;

public class FileOutputStream
extends java.io.FileOutputStream
implements Serializable,
Component {
    private static final long serialVersionUID = -5546948914644351678L;
    private File file;

    private FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    private FileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
        this.file = file;
    }

    public static FileOutputStream create(File file, boolean append) {
        return Executor.get(() -> new FileOutputStream(file, append));
    }

    public static FileOutputStream create(File file) {
        return Executor.get(() -> new FileOutputStream(file));
    }

    public static FileOutputStream create(String absolutePath, boolean append) throws FileNotFoundException {
        return new FileOutputStream(absolutePath != null ? new File(absolutePath) : null, append);
    }

    public static FileOutputStream create(String absolutePath) throws FileNotFoundException {
        return new FileOutputStream(absolutePath != null ? new File(absolutePath) : null, false);
    }

    @Override
    public void close() {
        Executor.run(() -> super.close());
        this.file = null;
    }

    public File getFile() {
        return this.file;
    }
}

