/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;

public class TCFBreakpointsModel {
    public static final String CDATA_CLIENT_ID = "ClientID";
    public static final String CDATA_TYPE = "Type";
    public static final String CDATA_FILE = "File";
    public static final String CDATA_MARKER = "Marker";
    public static final String ATTR_ID = "org.eclipse.tcf.debug.ID";
    public static final String ATTR_STATUS = "org.eclipse.tcf.debug.Status";
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_ENABLED = "org.eclipse.debug.core.enabled";
    public static final String ATTR_INSTALL_COUNT = "org.eclipse.cdt.debug.core.installCount";
    public static final String ATTR_ADDRESS = "org.eclipse.cdt.debug.core.address";
    public static final String ATTR_FUNCTION = "org.eclipse.cdt.debug.core.function";
    public static final String ATTR_EXPRESSION = "org.eclipse.cdt.debug.core.expression";
    public static final String ATTR_READ = "org.eclipse.cdt.debug.core.read";
    public static final String ATTR_WRITE = "org.eclipse.cdt.debug.core.write";
    public static final String ATTR_SIZE = "org.eclipse.cdt.debug.core.range";
    public static final String ATTR_FILE = "org.eclipse.cdt.debug.core.sourceHandle";
    public static final String ATTR_LINE = "lineNumber";
    public static final String ATTR_CHAR = "charStart";
    public static final String ATTR_REQESTED_FILE = "requestedSourceHandle";
    public static final String ATTR_REQESTED_LINE = "requestedLine";
    public static final String ATTR_REQESTED_CHAR = "requestedCharStart";
    public static final String ATTR_CONDITION = "org.eclipse.cdt.debug.core.condition";
    public static final String ATTR_PRINTF_STRING = "org.eclipse.cdt.debug.core.printf_string";
    public static final String ATTR_IGNORE_COUNT = "org.eclipse.cdt.debug.core.ignoreCount";
    public static final String ATTR_CONTEXTNAMES = "org.eclipse.tcf.debug.ContextNames";
    public static final String ATTR_CONTEXTIDS = "org.eclipse.tcf.debug.ContextIds";
    public static final String ATTR_EXE_PATHS = "org.eclipse.tcf.debug.ExecPaths";
    public static final String ATTR_STOP_GROUP = "org.eclipse.tcf.debug.StopGroup";
    public static final String ATTR_CONTEXT_QUERY = "org.eclipse.tcf.debug.ContextQuery";
    public static final String ATTR_LINE_OFFSET = "org.eclipse.tcf.debug.LineOffset";
    public static final String ATTR_SKIP_PROLOGUE = "org.eclipse.tcf.debug.SkipPrologue";
    public static final String ATTR_CT_INP = "org.eclipse.tcf.debug.CrossTriggerInp";
    public static final String ATTR_CT_OUT = "org.eclipse.tcf.debug.CrossTriggerOut";
    public static final String ATTR_EVENT_TYPE = "org.eclipse.cdt.debug.core.eventbreakpoint_event_id";
    public static final String ATTR_EVENT_ARGS = "org.eclipse.cdt.debug.core.eventbreakpoint_event_arg";
    public static final String ATTR_TYPE = "org.eclipse.cdt.debug.core.breakpointType";
    public static final String ATTR_TCF_STAMP = "org.eclipse.tcf.debug.tcfStamp";
    public static final int ATTR_TYPE_TEMPORARY = 1;
    public static final int ATTR_TYPE_REGULAR = 0;
    public static final int ATTR_TYPE_HARDWARE = 2;
    public static final int ATTR_TYPE_SOFTWARE = 4;
    private final IBreakpointManager bp_manager = DebugPlugin.getDefault().getBreakpointManager();
    private final HashMap<IChannel, Map<String, Object>> channels = new HashMap();
    private final HashMap<String, IBreakpoint> id2bp = new HashMap();
    private final IBreakpointListener breakpoint_listener = new IBreakpointListener(){

        public void breakpointAdded(IBreakpoint breakpoint) {
            try {
                new BreakpointUpdate(TCFBreakpointsModel.this, breakpoint, false){

                    @Override
                    void update() {
                        this.service.add(this.tcf_attrs, this.done);
                    }
                }.exec();
            }
            catch (Throwable x) {
                Activator.log("Unhandled exception in breakpoint listener", x);
            }
        }

        private Set<String> calcMarkerDeltaKeys(IMarker marker, IMarkerDelta delta) throws CoreException {
            HashSet<String> keys = new HashSet<String>();
            if (delta == null) {
                return keys;
            }
            Map m0 = delta.getAttributes();
            Map m1 = marker.getAttributes();
            if (m0 != null) {
                keys.addAll(m0.keySet());
            }
            if (m1 != null) {
                keys.addAll(m1.keySet());
            }
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object v1;
                String key = (String)i.next();
                Object v0 = m0 != null ? (Object)m0.get(key) : null;
                Object v02 = v1 = m1 != null ? m1.get(key) : null;
                if (v0 instanceof String && ((String)v0).length() == 0) {
                    v0 = null;
                }
                if (v1 instanceof String && ((String)v1).length() == 0) {
                    v1 = null;
                }
                if (v0 instanceof Boolean && !((Boolean)v0).booleanValue()) {
                    v0 = null;
                }
                if (v1 instanceof Boolean && !((Boolean)v1).booleanValue()) {
                    v1 = null;
                }
                if (v0 == null != (v1 == null) || v0 != null && !v0.equals(v1)) continue;
                i.remove();
            }
            if (marker.getAttribute(TCFBreakpointsModel.ATTR_REQESTED_FILE, "").length() > 0) {
                keys.remove(TCFBreakpointsModel.ATTR_FILE);
            }
            if (marker.getAttribute(TCFBreakpointsModel.ATTR_REQESTED_LINE, -1) >= 0) {
                keys.remove(TCFBreakpointsModel.ATTR_LINE);
            }
            if (marker.getAttribute(TCFBreakpointsModel.ATTR_REQESTED_CHAR, -1) >= 0) {
                keys.remove(TCFBreakpointsModel.ATTR_CHAR);
            }
            keys.remove(TCFBreakpointsModel.ATTR_INSTALL_COUNT);
            keys.remove(TCFBreakpointsModel.ATTR_TCF_STAMP);
            keys.remove(TCFBreakpointsModel.ATTR_MESSAGE);
            keys.remove(TCFBreakpointsModel.ATTR_STATUS);
            return keys;
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            try {
                final Set<String> s = this.calcMarkerDeltaKeys(breakpoint.getMarker(), delta);
                if (s.isEmpty()) {
                    return;
                }
                new BreakpointUpdate(TCFBreakpointsModel.this, breakpoint, false){

                    @Override
                    void update() {
                        if (s.size() == 1 && s.contains(TCFBreakpointsModel.ATTR_ENABLED)) {
                            Boolean enabled = (Boolean)this.tcf_attrs.get("Enabled");
                            if (enabled == null || !enabled.booleanValue()) {
                                this.service.disable(new String[]{this.marker_id}, this.done);
                            } else {
                                this.service.enable(new String[]{this.marker_id}, this.done);
                            }
                        } else {
                            this.service.change(this.tcf_attrs, this.done);
                        }
                    }
                }.exec();
            }
            catch (Throwable x) {
                Activator.log("Unhandled exception in breakpoint listener", x);
            }
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
            try {
                new BreakpointUpdate(TCFBreakpointsModel.this, breakpoint, true){

                    @Override
                    void update() {
                        this.service.remove(new String[]{this.marker_id}, this.done);
                    }
                }.exec();
            }
            catch (Throwable x) {
                Activator.log("Unhandled exception in breakpoint listener", x);
            }
        }
    };
    private final IBreakpointManagerListener manager_listener = new IBreakpointManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void breakpointManagerEnablementChanged(final boolean enabled) {
            try {
                IBreakpoint[] arr = TCFBreakpointsModel.this.bp_manager.getBreakpoints();
                if (arr == null || arr.length == 0) {
                    return;
                }
                final HashMap<String, IBreakpoint> map = new HashMap<String, IBreakpoint>();
                int i = 0;
                while (i < arr.length) {
                    String id;
                    IMarker marker = arr[i].getMarker();
                    Boolean b = marker.getAttribute(TCFBreakpointsModel.ATTR_ENABLED, Boolean.FALSE.booleanValue());
                    if (b.booleanValue() && (id = TCFBreakpointsModel.getBreakpointID(arr[i])) != null) {
                        map.put(id, arr[i]);
                    }
                    ++i;
                }
                if (map.isEmpty()) {
                    return;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (TCFBreakpointsModel.this.disposed) {
                            return;
                        }
                        for (final IChannel channel : TCFBreakpointsModel.this.channels.keySet()) {
                            IBreakpoints service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                            HashSet<String> ids = new HashSet<String>();
                            for (String id : map.keySet()) {
                                IBreakpoint bp = (IBreakpoint)map.get(id);
                                if (!TCFBreakpointsModel.this.isSupported(channel, bp)) continue;
                                ids.add(id);
                            }
                            IBreakpoints.DoneCommand done = new IBreakpoints.DoneCommand(){

                                public void doneCommand(IToken token, Exception error) {
                                    if (error != null) {
                                        channel.terminate((Throwable)error);
                                    }
                                }
                            };
                            if (enabled) {
                                service.enable(ids.toArray(new String[ids.size()]), done);
                                continue;
                            }
                            service.disable(ids.toArray(new String[ids.size()]), done);
                        }
                        Protocol.sync((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Map map2 = map;
                                synchronized (map2) {
                                    map.notify();
                                }
                            }
                        });
                    }
                };
                HashMap<String, IBreakpoint> hashMap = map;
                synchronized (hashMap) {
                    if (!$assertionsDisabled && Protocol.isDispatchThread()) {
                        throw new AssertionError();
                    }
                    Protocol.invokeLater((Runnable)r);
                    map.wait();
                }
            }
            catch (Throwable x) {
                Activator.log("Unhandled exception in breakpoint listener", x);
            }
        }
    };
    private boolean disposed;

    public static TCFBreakpointsModel getBreakpointsModel() {
        return Activator.getBreakpointsModel();
    }

    public void dispose() {
        this.bp_manager.removeBreakpointListener(this.breakpoint_listener);
        this.bp_manager.removeBreakpointManagerListener(this.manager_listener);
        this.channels.clear();
        this.disposed = true;
    }

    public boolean isSupported(IChannel channel, IBreakpoint bp) {
        return true;
    }

    public static String getBreakpointID(IBreakpoint bp) throws CoreException {
        IMarker marker = bp.getMarker();
        String id = (String)marker.getAttributes().get(ATTR_ID);
        if (id != null) {
            return id;
        }
        id = marker.getResource().getLocationURI().toString();
        return String.valueOf(id) + ':' + marker.getId();
    }

    public IBreakpoint getBreakpoint(String id) {
        assert (Protocol.isDispatchThread());
        return this.id2bp.get(id);
    }

    public static boolean isLocal(Map<String, Object> properties) {
        if (properties == null) {
            return false;
        }
        Map client_data = (Map)properties.get("ClientData");
        if (client_data == null) {
            return false;
        }
        String id = (String)client_data.get(CDATA_CLIENT_ID);
        return Activator.getClientID().equals(id);
    }

    public static boolean isLocal(IMarker marker) {
        Map marker_attrs;
        block3: {
            try {
                marker_attrs = marker.getAttributes();
                if (marker_attrs != null) break block3;
                return false;
            }
            catch (CoreException e) {
                return false;
            }
        }
        return !Boolean.FALSE.equals(marker_attrs.get("org.eclipse.debug.core.persisted"));
    }

    public void downloadBreakpoints(final IChannel channel, final Runnable done) throws IOException, CoreException {
        assert (!this.disposed);
        assert (Protocol.isDispatchThread());
        final IBreakpoints service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
        if (service == null) {
            Protocol.invokeLater((Runnable)done);
            return;
        }
        service.getCapabilities(null, new IBreakpoints.DoneGetCapabilities(){

            public void doneGetCapabilities(IToken token, Exception error, Map<String, Object> capabilities) {
                if (channel.getState() != 1) {
                    Protocol.invokeLater((Runnable)done);
                    return;
                }
                if (TCFBreakpointsModel.this.channels.isEmpty()) {
                    TCFBreakpointsModel.this.bp_manager.addBreakpointListener(TCFBreakpointsModel.this.breakpoint_listener);
                    TCFBreakpointsModel.this.bp_manager.addBreakpointManagerListener(TCFBreakpointsModel.this.manager_listener);
                }
                channel.addChannelListener(new IChannel.IChannelListener(){

                    public void congestionLevel(int level) {
                    }

                    public void onChannelClosed(Throwable error) {
                        if (TCFBreakpointsModel.this.disposed) {
                            return;
                        }
                        TCFBreakpointsModel.this.channels.remove(channel);
                        if (TCFBreakpointsModel.this.channels.isEmpty()) {
                            TCFBreakpointsModel.this.bp_manager.removeBreakpointListener(TCFBreakpointsModel.this.breakpoint_listener);
                            TCFBreakpointsModel.this.bp_manager.removeBreakpointManagerListener(TCFBreakpointsModel.this.manager_listener);
                            TCFBreakpointsModel.this.id2bp.clear();
                        }
                    }

                    public void onChannelOpened() {
                    }
                });
                TCFBreakpointsModel.this.channels.put(channel, capabilities);
                IBreakpoint[] arr = TCFBreakpointsModel.this.bp_manager.getBreakpoints();
                if (arr != null && arr.length > 0) {
                    ArrayList<Map<String, Object>> bps = new ArrayList<Map<String, Object>>(arr.length);
                    int i = 0;
                    while (i < arr.length) {
                        try {
                            String id;
                            if (TCFBreakpointsModel.this.isSupported(channel, arr[i]) && (id = TCFBreakpointsModel.getBreakpointID(arr[i])) != null && arr[i].isPersisted()) {
                                IMarker marker = arr[i].getMarker();
                                String file = TCFBreakpointsModel.this.getFilePath(marker.getResource());
                                bps.add(TCFBreakpointsModel.this.toBreakpointAttributes(channel, id, file, marker.getType(), marker.getAttributes()));
                                TCFBreakpointsModel.this.id2bp.put(id, arr[i]);
                            }
                        }
                        catch (Exception x) {
                            Activator.log("Cannot get breakpoint attributes", x);
                        }
                        ++i;
                    }
                    if (!bps.isEmpty()) {
                        Map[] bp_arr = bps.toArray(new Map[bps.size()]);
                        service.set(bp_arr, new IBreakpoints.DoneCommand(){

                            public void doneCommand(IToken token, Exception error) {
                                if (error == null) {
                                    done.run();
                                } else {
                                    channel.terminate((Throwable)error);
                                }
                            }
                        });
                        return;
                    }
                }
                Protocol.invokeLater((Runnable)done);
            }
        });
    }

    private String getFilePath(IResource resource) throws IOException {
        if (resource == ResourcesPlugin.getWorkspace().getRoot()) {
            return null;
        }
        IPath p = resource.getRawLocation();
        if (p == null) {
            return null;
        }
        return p.toFile().getCanonicalPath();
    }

    public Map<String, Object> toMarkerAttributes(Map<String, Object> p) {
        String type;
        Boolean temporary;
        Number ignore_count;
        String event_args;
        String event_type;
        String condition;
        Number line;
        Map<String, Object> m;
        assert (!this.disposed);
        assert (Protocol.isDispatchThread());
        Map client_data = (Map)p.get("ClientData");
        if (client_data != null && (m = (Map)client_data.get(CDATA_MARKER)) != null) {
            m = new HashMap(m);
            m.put(ATTR_ID, p.get("ID"));
            Boolean enabled = (Boolean)p.get("Enabled");
            m.put(ATTR_ENABLED, enabled == null ? Boolean.FALSE : enabled);
            return m;
        }
        m = new HashMap();
        for (Map.Entry<String, Object> e : p.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (key.equals("Enabled") || key.equals(CDATA_FILE) || key.equals("Line") || key.equals("Column") || key.equals("Location") || key.equals("AccessMode") || key.equals("Size") || key.equals("Condition") || key.equals("EventType") || key.equals("EventArgs")) continue;
            if ("ContextIds".equals(key) || "ContextNames".equals(key) || "StopGroup".equals(key) || "ExecPaths".equals(key)) {
                StringBuffer bf;
                if (val instanceof String[]) {
                    bf = new StringBuffer();
                    String[] stringArray = (String[])val;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (bf.length() > 0) {
                            bf.append(',');
                        }
                        bf.append(s);
                        ++n2;
                    }
                    if (bf.length() == 0) continue;
                    val = bf.toString();
                } else if (val instanceof Collection) {
                    bf = new StringBuffer();
                    for (String s : (Collection)val) {
                        if (bf.length() > 0) {
                            bf.append(',');
                        }
                        bf.append(s);
                    }
                    if (bf.length() == 0) continue;
                    val = bf.toString();
                }
            }
            if (!(val instanceof String || val instanceof Boolean || val instanceof Integer)) {
                try {
                    val = "JSON:" + JSON.toJSON((Object)val);
                }
                catch (IOException x) {
                    continue;
                }
            }
            m.put("org.eclipse.tcf.debug." + key, val);
        }
        Boolean enabled = (Boolean)p.get("Enabled");
        m.put(ATTR_ENABLED, enabled == null ? Boolean.FALSE : enabled);
        String location = (String)p.get("Location");
        if (location != null && location.length() > 0) {
            int access_mode = 4;
            Number access_mode_num = (Number)p.get("AccessMode");
            if (access_mode_num != null) {
                access_mode = access_mode_num.intValue();
            }
            if ((access_mode & 4) != 0) {
                if (Character.isDigit(location.charAt(0))) {
                    m.put(ATTR_ADDRESS, location);
                } else {
                    m.put(ATTR_FUNCTION, location);
                }
            } else {
                m.put(ATTR_EXPRESSION, location.replaceFirst("^&\\((.+)\\)$", "$1"));
                m.put(ATTR_READ, (access_mode & 1) != 0);
                m.put(ATTR_WRITE, (access_mode & 2) != 0);
            }
            Number size_num = (Number)p.get("Size");
            if (size_num != null) {
                m.put(ATTR_SIZE, size_num.toString());
            }
        }
        m.put("org.eclipse.debug.core.registered", Boolean.TRUE);
        m.put("org.eclipse.debug.core.persisted", Boolean.TRUE);
        m.put("org.eclipse.debug.core.id", "org.eclipse.tcf.debug");
        String file = (String)p.get(CDATA_FILE);
        if (file != null && file.length() > 0) {
            m.put(ATTR_FILE, file);
        }
        if ((line = (Number)p.get("Line")) != null) {
            m.put(ATTR_LINE, line.intValue());
            Number column = (Number)p.get("Column");
            if (column != null) {
                m.put(ATTR_CHAR, new Integer(column.intValue()));
                m.put("charEnd", new Integer(column.intValue() + 1));
            }
        }
        if ((condition = (String)p.get("Condition")) != null && condition.length() > 0) {
            m.put(ATTR_CONDITION, condition);
        }
        if ((event_type = (String)p.get("EventType")) != null && event_type.length() > 0) {
            m.put(ATTR_EVENT_TYPE, event_type);
        }
        if ((event_args = (String)p.get("EventArgs")) != null && event_args.length() > 0) {
            m.put(ATTR_EVENT_ARGS, event_args);
        }
        if ((ignore_count = (Number)p.get("IgnoreCount")) != null) {
            m.put(ATTR_IGNORE_COUNT, ignore_count);
        }
        if ((temporary = (Boolean)p.get("Temporary")) != null && temporary.booleanValue()) {
            Integer cdt_type = (Integer)m.get(ATTR_TYPE);
            cdt_type = cdt_type != null ? cdt_type : 0;
            cdt_type = cdt_type | 1;
            m.put(ATTR_TYPE, cdt_type);
        }
        if ((type = (String)p.get("BreakpointType")) != null) {
            Integer cdt_type = (Integer)m.get(ATTR_TYPE);
            cdt_type = cdt_type != null ? cdt_type : 0;
            if ("Hardware".equals(type)) {
                cdt_type = cdt_type | 2;
            } else if ("Software".equals(type)) {
                cdt_type = cdt_type | 4;
            }
            m.put(ATTR_TYPE, cdt_type);
        }
        String msg = null;
        msg = location != null ? location : (file != null && line != null ? String.valueOf(file) + ":" + line : (String)p.get("ID"));
        m.put(ATTR_MESSAGE, "Breakpoint: " + msg);
        m.put(ATTR_TCF_STAMP, Boolean.TRUE.toString());
        return m;
    }

    public Map<String, Object> toBreakpointAttributes(IChannel channel, String id, String marker_file, String marker_type, Map<String, Object> p) {
        Integer cdt_type;
        Number ignore_count;
        String event_args;
        String event_type;
        String address;
        String expr;
        String file;
        Object obj;
        assert (!this.disposed);
        assert (Protocol.isDispatchThread());
        HashMap<String, Object> m = new HashMap<String, Object>();
        Map<String, Object> capabilities = this.channels.get(channel);
        HashMap<String, String> client_data = null;
        if (capabilities != null && (obj = capabilities.get("ClientData")) instanceof Boolean && ((Boolean)obj).booleanValue()) {
            client_data = new HashMap<String, String>();
        }
        m.put("ID", id);
        if (client_data != null) {
            m.put("ClientData", client_data);
            client_data.put(CDATA_CLIENT_ID, Activator.getClientID());
            if (marker_type != null) {
                client_data.put(CDATA_TYPE, marker_type);
            }
            if (marker_file != null) {
                client_data.put(CDATA_FILE, marker_file);
            }
            HashMap<String, Object> x = new HashMap<String, Object>(p);
            x.remove(ATTR_INSTALL_COUNT);
            x.remove(ATTR_TCF_STAMP);
            x.remove(ATTR_STATUS);
            client_data.put(CDATA_MARKER, (String)((Object)x));
        }
        for (Map.Entry<String, Object> e : p.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            if (key.equals(ATTR_STATUS) || key.equals(ATTR_TCF_STAMP) || !key.startsWith("org.eclipse.tcf.debug")) continue;
            String tcf_key = key.substring("org.eclipse.tcf.debug".length() + 1);
            if (val instanceof String) {
                String str = (String)val;
                if ("ContextIds".equals(tcf_key)) {
                    if (str.length() == 0) continue;
                    val = this.filterContextIds(channel, str.split(",\\s*"));
                } else if ("ContextQuery".equals(tcf_key)) {
                    if (str.length() == 0) {
                        continue;
                    }
                } else if ("ContextNames".equals(tcf_key) || "StopGroup".equals(tcf_key) || "ExecPaths".equals(tcf_key)) {
                    val = str.split(",\\s*");
                } else if (str.startsWith("JSON:")) {
                    try {
                        val = JSON.parseOne((byte[])str.substring(5).getBytes("UTF-8"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            m.put(tcf_key, val);
        }
        Boolean enabled = (Boolean)p.get(ATTR_ENABLED);
        if (enabled != null && enabled.booleanValue() && this.bp_manager.isEnabled()) {
            m.put("Enabled", enabled);
        }
        if ((file = (String)p.get(ATTR_REQESTED_FILE)) == null || file.length() == 0) {
            file = (String)p.get(ATTR_FILE);
        }
        if (file == null || file.length() == 0) {
            file = marker_file;
        }
        if (file != null && file.trim().length() > 0) {
            Object obj2;
            String name = file;
            boolean file_mapping = false;
            if (capabilities != null && (obj2 = capabilities.get("FileMapping")) instanceof Boolean) {
                file_mapping = (Boolean)obj2;
            }
            if (!file_mapping) {
                int j;
                int i = file.lastIndexOf(47);
                if (i > (j = file.lastIndexOf(92))) {
                    name = file.substring(i + 1);
                } else if (i < j) {
                    name = file.substring(j + 1);
                }
            }
            m.put(CDATA_FILE, name);
            Integer line = (Integer)p.get(ATTR_REQESTED_LINE);
            if (line == null || line < 0) {
                line = (Integer)p.get(ATTR_LINE);
            }
            if (line != null && line >= 0) {
                m.put("Line", line);
                Integer column = (Integer)p.get(ATTR_REQESTED_CHAR);
                if (column == null || column < 0) {
                    column = (Integer)p.get(ATTR_CHAR);
                }
                if (column != null && column >= 0) {
                    m.put("Column", column);
                }
            }
        }
        if (p.get(ATTR_EXPRESSION) != null) {
            expr = (String)p.get(ATTR_EXPRESSION);
            if (expr != null && expr.length() != 0) {
                int size;
                boolean writeAccess = Boolean.TRUE.equals(p.get(ATTR_WRITE));
                boolean readAccess = Boolean.TRUE.equals(p.get(ATTR_READ));
                int accessMode = 0;
                if (readAccess) {
                    accessMode |= 1;
                }
                if (writeAccess) {
                    accessMode |= 2;
                }
                m.put("AccessMode", accessMode);
                Object range = p.get(ATTR_SIZE);
                if (range != null && (size = Integer.parseInt(range.toString())) > 0) {
                    m.put("Size", size);
                }
                if (!Character.isDigit(expr.charAt(0))) {
                    expr = "&(" + expr + ')';
                }
                m.put("Location", expr);
                if (m.get(CDATA_FILE) != null && m.get("Line") == null) {
                    m.put("Line", 1);
                }
            }
        } else if (p.get(ATTR_FUNCTION) != null) {
            Object obj3;
            expr = (String)p.get(ATTR_FUNCTION);
            if (expr != null && expr.length() != 0) {
                int paren = expr.indexOf(40);
                if (paren > 0) {
                    expr = expr.substring(0, paren);
                }
                m.put("Location", expr);
            }
            if (!m.containsKey("SkipPrologue") && capabilities != null && (obj3 = capabilities.get("SkipPrologue")) instanceof Boolean && ((Boolean)obj3).booleanValue()) {
                m.put("SkipPrologue", true);
            }
        } else if (file == null && (address = (String)p.get(ATTR_ADDRESS)) != null && address.length() > 0) {
            m.put("Location", address);
        }
        String condition = (String)p.get(ATTR_CONDITION);
        String printf_string = (String)p.get(ATTR_PRINTF_STRING);
        if (printf_string != null && printf_string.length() > 0) {
            condition = condition != null && condition.length() > 0 ? String.valueOf('(') + condition + ") && " + "$printf(" + printf_string + ')' : "$printf(" + printf_string + ')';
        }
        if (condition != null && condition.length() > 0) {
            m.put("Condition", condition);
        }
        if ((event_type = (String)p.get(ATTR_EVENT_TYPE)) != null && event_type.length() > 0) {
            m.put("EventType", event_type);
        }
        if ((event_args = (String)p.get(ATTR_EVENT_ARGS)) != null && event_args.length() > 0) {
            m.put("EventArgs", event_args);
        }
        if ((ignore_count = (Number)p.get(ATTR_IGNORE_COUNT)) != null && ignore_count.intValue() > 0) {
            m.put("IgnoreCount", ignore_count);
        }
        if ((cdt_type = (Integer)p.get(ATTR_TYPE)) != null) {
            if ((cdt_type & 1) != 0) {
                m.put("Temporary", true);
            }
            if ((cdt_type & 2) != 0) {
                m.put("BreakpointType", "Hardware");
            } else if ((cdt_type & 4) != 0) {
                m.put("BreakpointType", "Software");
            } else {
                m.put("BreakpointType", "Auto");
            }
        }
        return m;
    }

    private String[] filterContextIds(IChannel channel, String[] scopeIds) {
        String sessionId = this.getSessionId(channel);
        ArrayList<String> contextIds = new ArrayList<String>();
        String[] stringArray = scopeIds;
        int n = scopeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String scopeId = stringArray[n2];
            if (scopeId.length() != 0) {
                int slash = scopeId.indexOf(47);
                if (slash < 0) {
                    contextIds.add(scopeId);
                } else if (sessionId != null && sessionId.equals(scopeId.substring(0, slash))) {
                    contextIds.add(scopeId.substring(slash + 1));
                }
            }
            ++n2;
        }
        return contextIds.toArray(new String[contextIds.size()]);
    }

    private String getSessionId(IChannel channel) {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && channel == ((TCFLaunch)launch).getChannel()) {
                ILaunchConfiguration lc = launch.getLaunchConfiguration();
                return lc != null ? lc.getName() : null;
            }
            ++n2;
        }
        return null;
    }

    private abstract class BreakpointUpdate
    implements Runnable {
        private final IBreakpoint breakpoint;
        private boolean removed;
        protected final Map<String, Object> marker_attrs;
        protected final boolean is_local;
        protected final String marker_id;
        private final String marker_file;
        private final String marker_type;
        IBreakpoints service;
        IBreakpoints.DoneCommand done;
        Map<String, Object> tcf_attrs;

        BreakpointUpdate(IBreakpoint breakpoint, boolean removed) throws CoreException, IOException {
            this.breakpoint = breakpoint;
            this.removed = removed;
            IMarker marker = breakpoint.getMarker();
            this.marker_attrs = new HashMap<String, Object>(marker.getAttributes());
            this.is_local = TCFBreakpointsModel.isLocal(marker);
            this.marker_file = TCFBreakpointsModel.this.getFilePath(breakpoint.getMarker().getResource());
            this.marker_type = breakpoint.getMarker().getType();
            this.marker_id = TCFBreakpointsModel.getBreakpointID(breakpoint);
        }

        synchronized void exec() throws InterruptedException {
            assert (!Protocol.isDispatchThread());
            if (this.marker_id != null) {
                Protocol.invokeLater((Runnable)this);
                this.wait();
            }
        }

        @Override
        public void run() {
            if (TCFBreakpointsModel.this.disposed) {
                return;
            }
            if (this.removed) {
                TCFBreakpointsModel.this.id2bp.remove(this.marker_id);
            } else {
                TCFBreakpointsModel.this.id2bp.put(this.marker_id, this.breakpoint);
            }
            if (this.is_local) {
                for (final IChannel channel : TCFBreakpointsModel.this.channels.keySet()) {
                    this.tcf_attrs = TCFBreakpointsModel.this.toBreakpointAttributes(channel, this.marker_id, this.marker_file, this.marker_type, this.marker_attrs);
                    this.service = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                    if (!TCFBreakpointsModel.this.isSupported(channel, this.breakpoint)) continue;
                    this.done = new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                channel.terminate((Throwable)error);
                            }
                        }
                    };
                    this.update();
                }
            }
            Protocol.sync((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BreakpointUpdate breakpointUpdate = BreakpointUpdate.this;
                    synchronized (breakpointUpdate) {
                        BreakpointUpdate.this.notify();
                    }
                }
            });
        }

        abstract void update();
    }
}

