/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class StatusLineLabelProvider
extends LabelProvider {
    private Image fInterfaceImage = PHPPluginImages.get("org.eclipse.php.ui.phpinterfacedata.png");
    private Image fClassImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");

    public String getText(Object element) {
        if (element != null) {
            String elementName = "";
            String projectName = "";
            IType type = null;
            if (element instanceof DLTKSearchTypeNameMatch) {
                DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                type = typeMatch.getType();
                elementName = type.getElementName();
            } else if (element instanceof SourceType) {
                type = (IType)element;
                elementName = type.getElementName();
                projectName = type.getResource().getProject().getName();
            }
            if (type != null) {
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(type.getPath());
                if (member != null) {
                    projectName = member.getProject().getName();
                } else if (type.getParent() instanceof ExternalSourceModule) {
                    IModelElement parent = type.getParent();
                    while ((parent = parent.getParent()) != null && parent.getElementType() != 2) {
                    }
                    if (parent instanceof IScriptProject) {
                        projectName = ((IScriptProject)parent).getElementName();
                    }
                }
            }
            StringBuilder result = new StringBuilder(elementName);
            result.append(" - ");
            result.append(projectName);
            return result.toString();
        }
        return "";
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element != null) {
            IType type = null;
            if (element instanceof DLTKSearchTypeNameMatch) {
                DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                type = typeMatch.getType();
            }
            if (element instanceof SourceType) {
                type = (IType)element;
            }
            if (type == null) {
                return null;
            }
            try {
                if (PHPFlags.isClass((int)type.getFlags())) {
                    result = this.fClassImage;
                } else if (PHPFlags.isInterface((int)type.getFlags())) {
                    result = this.fInterfaceImage;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        return result;
    }
}

