/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.launcher;

import java.security.MessageDigest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.server.core.tunneling.TunnelTester;
import org.eclipse.php.profile.ui.launcher.AbstractPHPLaunchConfigurationProfilerTab;
import org.eclipse.php.profile.ui.launcher.IProfilerLaunchSettingsSection;
import org.eclipse.php.profile.ui.launcher.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractProfileWebLaunchSettingsSection
implements IProfilerLaunchSettingsSection {
    protected AbstractPHPLaunchConfigurationProfilerTab.WidgetListener widgetListener;
    protected Group tunnelGroup;
    protected Button profileThroughTunnel;
    protected Label nameLabel;
    protected Text userName;
    protected Label passwordLabel;
    protected Text password;
    protected Button testButton;
    protected CLabel testResultLabel;
    private ILaunchConfiguration configuration;
    private boolean isSSHCredentialsChange;

    @Override
    public final void createSection(Composite parent, AbstractPHPLaunchConfigurationProfilerTab.WidgetListener widgetListener) {
        this.widgetListener = widgetListener;
        this.buildSection(parent);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        this.configuration = configuration;
        if (this.tunnelGroup != null) {
            try {
                boolean isUsingTunnel = configuration.getAttribute("org.eclipse.php.debug.core.UseSSHTunnel", false);
                this.profileThroughTunnel.setSelection(isUsingTunnel);
                this.updateTunnelComponents(isUsingTunnel);
                if (isUsingTunnel && this.tunnelGroup != null) {
                    this.userName.setText(configuration.getAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", ""));
                    if (this.userName.getText().length() > 0) {
                        try {
                            this.password.setText(PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.getConfiguration())).get(this.userName.getText(), ""));
                        }
                        catch (StorageException e) {
                            Logger.logException((String)"Error accessing the secured storage", (Throwable)e);
                            this.password.setText("");
                        }
                    } else {
                        this.password.setText("");
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        this.isValid(configuration);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.tunnelGroup != null) {
            configuration.setAttribute("org.eclipse.php.debug.core.UseSSHTunnel", this.profileThroughTunnel.getSelection());
            if (this.profileThroughTunnel.getSelection()) {
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", this.userName.getText().trim());
                String passwordDigest = Digester.digest(this.password.getText().trim());
                if (passwordDigest == null) {
                    passwordDigest = String.valueOf(this.password.getText().trim().hashCode());
                }
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", passwordDigest);
                try {
                    if (!this.isSSHCredentialsChange) {
                        PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.getConfiguration())).put(this.userName.getText(), this.password.getText().trim(), true);
                    }
                }
                catch (StorageException e) {
                    Logger.logException((String)"Error saving to the secured storage", (Throwable)e);
                }
            } else {
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", "");
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", "");
            }
        }
        this.isSSHCredentialsChange = false;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.configuration = configuration;
    }

    @Override
    public AbstractPHPLaunchConfigurationProfilerTab.StatusMessage isValid(ILaunchConfiguration configuration) {
        if (this.tunnelGroup != null && this.profileThroughTunnel.getSelection()) {
            boolean valid = this.userName.getText().trim().length() > 0;
            this.testButton.setEnabled(valid);
            if (!valid) {
                return new AbstractPHPLaunchConfigurationProfilerTab.StatusMessage(3, Messages.AbstractProfileWebLaunchSettingsSection_Missing_SSH_user_name);
            }
        }
        return new AbstractPHPLaunchConfigurationProfilerTab.StatusMessage(0, "");
    }

    protected void buildSection(Composite parent) {
        this.createTunnelGroup(parent);
    }

    protected void createTunnelGroup(Composite composite) {
        this.tunnelGroup = new Group(composite, 0);
        this.tunnelGroup.setLayout((Layout)new GridLayout(1, false));
        this.tunnelGroup.setLayoutData((Object)new GridData(768));
        this.tunnelGroup.setText(Messages.AbstractProfileWebLaunchSettingsSection_SSH_tunnel);
        this.profileThroughTunnel = new Button((Composite)this.tunnelGroup, 32);
        this.profileThroughTunnel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Profile_through_SSH_tunnel);
        Composite credentialsComposite = new Composite((Composite)this.tunnelGroup, 0);
        credentialsComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        credentialsComposite.setLayoutData((Object)data);
        this.nameLabel = new Label(credentialsComposite, 0);
        this.nameLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_User_name);
        this.userName = new Text(credentialsComposite, 2052);
        data = new GridData(768);
        data.widthHint = 200;
        this.userName.setLayoutData((Object)data);
        this.userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractProfileWebLaunchSettingsSection.this.isSSHCredentialsChange = true;
                AbstractProfileWebLaunchSettingsSection.this.updateTunnelComponents(true);
            }
        });
        this.passwordLabel = new Label(credentialsComposite, 0);
        this.passwordLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Password);
        this.password = new Text(credentialsComposite, 0x400804);
        data = new GridData(768);
        data.widthHint = 200;
        this.password.setLayoutData((Object)data);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractProfileWebLaunchSettingsSection.this.isSSHCredentialsChange = true;
                AbstractProfileWebLaunchSettingsSection.this.updateTunnelComponents(true);
            }
        });
        Composite testConnectionComposite = new Composite(credentialsComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        testConnectionComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        testConnectionComposite.setLayoutData((Object)data);
        this.testButton = new Button(testConnectionComposite, 8);
        this.testButton.setText(Messages.AbstractProfileWebLaunchSettingsSection_Test_connection);
        this.testResultLabel = new CLabel(testConnectionComposite, 0);
        this.testResultLabel.setLayoutData((Object)new GridData(768));
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractProfileWebLaunchSettingsSection.this.testTunnelConnection();
            }
        });
        this.testResultLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object messageData = AbstractProfileWebLaunchSettingsSection.this.testResultLabel.getData("info");
                if (messageData != null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractProfileWebLaunchSettingsSection_SSH_tunnel_test, (String)messageData.toString());
                }
            }
        });
        this.profileThroughTunnel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                boolean selection = b.getSelection();
                AbstractProfileWebLaunchSettingsSection.this.updateTunnelComponents(selection);
            }
        });
        this.userName.addModifyListener((ModifyListener)this.widgetListener);
        this.password.addModifyListener((ModifyListener)this.widgetListener);
        this.profileThroughTunnel.addSelectionListener((SelectionListener)this.widgetListener);
    }

    protected ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void updateTunnelComponents(boolean enabled) {
        this.testResultLabel.setText("");
        this.setEnabled(enabled, new Control[]{this.userName, this.password, this.nameLabel, this.passwordLabel, this.testResultLabel});
        this.testButton.setEnabled(enabled && this.userName.getText().trim().length() > 0);
    }

    protected void setEnabled(boolean enabled, Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
    }

    protected void testTunnelConnection() {
        this.testButton.setEnabled(false);
        this.testResultLabel.setForeground(Display.getDefault().getSystemColor(9));
        this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Testing_connection);
        this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
        this.testResultLabel.setData("info", null);
        UIJob connectionTest = new UIJob(Messages.AbstractProfileWebLaunchSettingsSection_SSH_tunnel_test){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                block15: {
                    try {
                        String remoteHost = PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)AbstractProfileWebLaunchSettingsSection.this.getConfiguration());
                        int port = PHPLaunchUtilities.getDebugPort((ILaunchConfiguration)AbstractProfileWebLaunchSettingsSection.this.getConfiguration());
                        if (remoteHost == null || remoteHost.length() == 0 || port < 0) {
                            AbstractProfileWebLaunchSettingsSection.this.testButton.setEnabled(true);
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            if (port > -1) {
                                AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Missing_host);
                                AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)Messages.AbstractProfileWebLaunchSettingsSection_Missing_host_address);
                            } else {
                                AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Error);
                                AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)Messages.AbstractProfileWebLaunchSettingsSection_Could_not_determine_port);
                            }
                        }
                        AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
                        IStatus connectionStatus = TunnelTester.test((String)remoteHost, (String)AbstractProfileWebLaunchSettingsSection.this.userName.getText().trim(), (String)AbstractProfileWebLaunchSettingsSection.this.password.getText().trim(), (int)port, (int)port);
                        AbstractProfileWebLaunchSettingsSection.this.testButton.setEnabled(true);
                        AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(null);
                        if (connectionStatus.isOK()) {
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Successfully_connected);
                            break block15;
                        }
                        if (connectionStatus.isMultiStatus()) {
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(8));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Undetermined);
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                            IStatus[] children = connectionStatus.getChildren();
                            if (children == null) break block15;
                            IStatus[] iStatusArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus child = iStatusArray[n2];
                                if (child.getSeverity() == 1 && child.getCode() == 300) {
                                    AbstractProfileWebLaunchSettingsSection.this.password.setText(child.getMessage());
                                    break block15;
                                }
                                ++n2;
                            }
                            break block15;
                        }
                        if (connectionStatus.getSeverity() == 2) {
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Connected_with_warnings);
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        } else if (connectionStatus.getSeverity() == 1) {
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Connected_with_warnings);
                            if (connectionStatus.getCode() == 300) {
                                AbstractProfileWebLaunchSettingsSection.this.password.setText(connectionStatus.getMessage());
                            }
                        } else if (connectionStatus.getSeverity() == 4) {
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Failed_to_connect);
                            AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        AbstractProfileWebLaunchSettingsSection.this.testButton.setEnabled(true);
                        AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setCursor(null);
                        AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setForeground(null);
                        AbstractProfileWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractProfileWebLaunchSettingsSection_Canceled);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        connectionTest.setUser(true);
        connectionTest.setPriority(30);
        connectionTest.schedule();
    }

    protected static class Digester {
        protected Digester() {
        }

        public static String digest(String content) {
            if (content == null) {
                return null;
            }
            if (content.length() == 0) {
                return "";
            }
            String passwordDigest = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(content.getBytes());
                byte[] digest = md.digest();
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (i < digest.length) {
                    String hex = Integer.toHexString(0xFF & digest[i]);
                    if (hex.length() == 1) {
                        buffer.append('0');
                    }
                    buffer.append(hex);
                    ++i;
                }
                passwordDigest = buffer.toString();
            }
            catch (Exception e) {
                Logger.logException((String)"Message digest error", (Throwable)e);
            }
            if (passwordDigest == null) {
                return null;
            }
            return passwordDigest;
        }
    }
}

