/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.php.internal.core.Logger;

public class PreferencesSupport {
    private Map<IProject, ProjectScope> projectToScope;
    private String nodeQualifier;

    public PreferencesSupport(String nodeQualifier) {
        this.nodeQualifier = nodeQualifier;
        this.projectToScope = new HashMap<IProject, ProjectScope>();
    }

    public String getProjectSpecificPreferencesValue(String key, String def, IProject project) {
        assert (project != null);
        IEclipsePreferences node = this.getPreferences(project);
        if (node != null) {
            return node.get(key, def);
        }
        return null;
    }

    public boolean getProjectSpecificBooleanPreferencesValue(String key, boolean def, IProject project) {
        assert (project != null);
        IEclipsePreferences node = this.getPreferences(project);
        if (node != null) {
            return node.getBoolean(key, def);
        }
        return def;
    }

    private IEclipsePreferences getPreferences(IProject project) {
        assert (project != null);
        ProjectScope scope = this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        return scope.getNode(this.nodeQualifier);
    }

    public String getPreferencesValue(String key, String def, IProject project) {
        if (project == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        String projectSpecificPreferencesValue = this.getProjectSpecificPreferencesValue(key, def, project);
        if (projectSpecificPreferencesValue == null) {
            return this.getWorkspacePreferencesValue(key);
        }
        return projectSpecificPreferencesValue;
    }

    public String getWorkspacePreferencesValue(String key) {
        return Platform.getPreferencesService().getString(this.nodeQualifier, key, null, null);
    }

    public static String getWorkspacePreferencesValue(String qualifier, String key) {
        return Platform.getPreferencesService().getString(qualifier, key, null, null);
    }

    public boolean setProjectSpecificPreferencesValue(String key, String value, IProject project) {
        IEclipsePreferences node;
        assert (project != null);
        if (!project.exists()) {
            return false;
        }
        ProjectScope scope = this.projectToScope.get(project);
        if (scope == null) {
            scope = new ProjectScope(project);
            this.projectToScope.put(project, scope);
        }
        if ((node = scope.getNode(this.nodeQualifier)) != null) {
            node.put(key, value);
            try {
                node.flush();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            return true;
        }
        return false;
    }
}

