/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.api.packages.DownloadClient;
import org.eclipse.php.composer.api.packages.PackageHelper;
import org.eclipse.php.composer.api.packages.SearchResult;

public class PackageSearch
extends DownloadClient {
    private int pageLimit = 3;

    public PackageSearch(String baseUrl) {
        super(baseUrl, true);
    }

    public List<MinimalPackage> search(String query) throws Exception {
        LinkedList<MinimalPackage> packages = new LinkedList<MinimalPackage>();
        SearchResult result = this.loadPackages(this.createUrl(query));
        if (result != null && result.results != null) {
            packages.addAll(result.results);
        }
        int current = 1;
        while (current < this.pageLimit && result != null && result.next != null && result.next.length() > 0) {
            result = this.loadPackages(result.next);
            if (result.results != null && result.results.size() > 0) {
                packages.addAll(result.results);
            }
            ++current;
        }
        return packages;
    }

    private SearchResult loadPackages(String url) throws Exception {
        this.downloader.setUrl(url);
        return PackageHelper.getSearchResult(this.downloader.download());
    }

    public int getPageLimit() {
        return this.pageLimit;
    }

    public void setPageLimit(int pageLimit) {
        this.pageLimit = pageLimit;
    }
}

