/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class CollectionIncludingAllOperation
extends AbstractSimpleBinaryOperation {
    public static final @NonNull CollectionIncludingAllOperation INSTANCE = new CollectionIncludingAllOperation();

    @Override
    public @NonNull CollectionValue evaluate(@Nullable Object left, @Nullable Object right) {
        CollectionValue leftCollectionValue = CollectionIncludingAllOperation.asCollectionValue(left);
        CollectionValue rightCollectionValue = CollectionIncludingAllOperation.asCollectionValue(right);
        return leftCollectionValue.includingAll(rightCollectionValue);
    }

    @Override
    public @Nullable Type resolveReturnType(@NonNull EnvironmentFactory environmentFactory, @NonNull CallExp callExp, @Nullable Type returnType) {
        Type sourceType;
        OCLExpression ownedSource;
        if (returnType instanceof CollectionType && (ownedSource = callExp.getOwnedSource()) != null && (sourceType = ownedSource.getType()) instanceof CollectionType) {
            Type argumentType;
            OCLExpression ownedArgument;
            CollectionType sourceCollectionType = (CollectionType)sourceType;
            List<OCLExpression> arguments = ((OperationCallExp)callExp).getOwnedArguments();
            if (arguments.size() > 0 && (ownedArgument = arguments.get(0)) != null && (argumentType = ownedArgument.getType()) instanceof CollectionType) {
                CollectionType argumentCollectionType = (CollectionType)argumentType;
                boolean isNullFree = sourceCollectionType.isIsNullFree() && argumentCollectionType.isIsNullFree();
                CollectionType returnCollectionType = (CollectionType)returnType;
                if (returnCollectionType.isIsNullFree() != isNullFree) {
                    @NonNull Type elementType = returnCollectionType.getElementType();
                    PivotMetamodelManager metamodelManager = (PivotMetamodelManager)environmentFactory.getMetamodelManager();
                    returnType = metamodelManager.getCollectionType(returnCollectionType.isOrdered(), returnCollectionType.isUnique(), elementType, isNullFree, returnCollectionType.getLowerValue(), returnCollectionType.getUpperValue());
                }
            }
        }
        return returnType;
    }
}

