/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.data.VMLocationData;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;

public class VMStackFrameData
implements Serializable {
    private static final long serialVersionUID = -1055712783030253722L;
    public final long id;
    private final @NonNull String uri;
    private final int lineNum;
    private final int charStart;
    private final int charEnd;
    public final @NonNull String module;
    public final @Nullable String elementSignature;
    public final @NonNull VMVariableData @NonNull [] visibleVariables;
    private transient VMLocationData location;

    public VMStackFrameData(long id, @NonNull String uri, @NonNull String module, @Nullable String elementSignature, int line, int startPosition, int endPosition, @NonNull VMVariableData @NonNull [] vars) {
        if (Arrays.asList(vars).contains(null)) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.uri = uri;
        this.module = module;
        this.elementSignature = elementSignature;
        this.visibleVariables = vars;
        this.lineNum = line;
        this.charStart = startPosition;
        this.charEnd = endPosition == startPosition ? endPosition + 1 : endPosition;
    }

    public synchronized @NonNull VMLocationData getLocation() {
        VMLocationData location2 = this.location;
        if (location2 == null) {
            this.location = location2 = new Loc(this);
        }
        return location2;
    }

    public @NonNull List<VMVariableData> getVisibleVariables() {
        return Arrays.asList(this.visibleVariables);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("(").append(this.id);
        s.append(", ").append(this.uri);
        s.append(":").append(this.module);
        s.append(":").append(this.lineNum);
        s.append(":").append(this.charStart);
        s.append(", ").append(this.elementSignature);
        VMVariableData[] visibleVariables2 = this.visibleVariables;
        if (visibleVariables2 != null) {
            s.append(", {");
            int i = 0;
            while (i < visibleVariables2.length) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("\n\t\t");
                s.append(visibleVariables2[i]);
                ++i;
            }
            s.append("}");
        }
        s.append(")");
        return s.toString();
    }

    private static class Loc
    implements VMLocationData {
        private static final long serialVersionUID = 300982114845658039L;
        private final @NonNull VMStackFrameData frame;

        private Loc(@NonNull VMStackFrameData frame) {
            this.frame = frame;
        }

        @Override
        public int getCharEnd() {
            return this.frame.charEnd;
        }

        @Override
        public int getCharStart() {
            return this.frame.charStart;
        }

        @Override
        public int getLineNum() {
            return this.frame.lineNum;
        }

        @Override
        public @NonNull String getURI() {
            return this.frame.uri;
        }

        @Override
        public @NonNull String getModule() {
            return this.frame.module;
        }

        @Override
        public @Nullable String getElementSignature() {
            return this.frame.elementSignature;
        }
    }
}

