/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.EclipseAetherFilterTransformer;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.MavenDependencyResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

class Maven31DependencyResolver
implements MavenDependencyResolver {
    private static final Class<?>[] ARG_CLASSES = new Class[]{Dependency.class, ArtifactTypeRegistry.class};
    private final RepositorySystem repositorySystem;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> aetherRepositories;

    Maven31DependencyResolver(RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, RepositorySystemSession session, List<RemoteRepository> aetherRepositories) {
        this.repositorySystem = repositorySystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.aetherRepositories = aetherRepositories;
    }

    private static org.eclipse.aether.graph.Dependency toDependency(DependableCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new org.eclipse.aether.graph.Dependency((Artifact)artifact, null);
    }

    private static org.eclipse.aether.graph.Dependency toDependency(Dependency root, ArtifactTypeRegistry typeRegistry) throws DependencyResolverException {
        Object[] args = new Object[]{root, typeRegistry};
        return (org.eclipse.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", ARG_CLASSES, args);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(DependableCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = this.createTypeRegistry();
        org.eclipse.aether.graph.Dependency aetherRoot = Maven31DependencyResolver.toDependency(coordinate, typeRegistry);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        return this.resolveDependencies(dependencyFilter, request);
    }

    private ArtifactTypeRegistry createTypeRegistry() throws DependencyResolverException {
        return (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, this.artifactHandlerManager);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(Model model, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(model.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), extension, model.getVersion());
        org.eclipse.aether.graph.Dependency aetherRoot = new org.eclipse.aether.graph.Dependency((Artifact)aetherArtifact, null);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        request.setDependencies(this.resolveDependencies(model.getDependencies()));
        DependencyManagement mavenDependencyManagement = model.getDependencyManagement();
        if (mavenDependencyManagement != null) {
            request.setManagedDependencies(this.resolveDependencies(model.getDependencyManagement().getDependencies()));
        }
        return this.resolveDependencies(dependencyFilter, request);
    }

    private List<org.eclipse.aether.graph.Dependency> resolveDependencies(Collection<Dependency> mavenDependencies) throws DependencyResolverException {
        if (mavenDependencies == null) {
            return Collections.emptyList();
        }
        ArtifactTypeRegistry typeRegistry = this.createTypeRegistry();
        ArrayList<org.eclipse.aether.graph.Dependency> aetherDependencies = new ArrayList<org.eclipse.aether.graph.Dependency>(mavenDependencies.size());
        for (Dependency mavenDependency : mavenDependencies) {
            aetherDependencies.add(Maven31DependencyResolver.toDependency(mavenDependency, typeRegistry));
        }
        return aetherDependencies;
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(Collection<Dependency> mavenDependencies, Collection<Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        List<org.eclipse.aether.graph.Dependency> aetherDeps = this.resolveDependencies(mavenDependencies);
        List<org.eclipse.aether.graph.Dependency> aetherManagedDependencies = this.resolveDependencies(managedMavenDependencies);
        CollectRequest request = new CollectRequest(aetherDeps, aetherManagedDependencies, this.aetherRepositories);
        return this.resolveDependencies(filter, request);
    }

    private Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = (DependencyFilter)dependencyFilter.transform((FilterTransformer)new EclipseAetherFilterTransformer());
            }
            DependencyRequest depRequest = new DependencyRequest(request, depFilter);
            final DependencyResult dependencyResults = this.repositorySystem.resolveDependencies(this.session, depRequest);
            return new Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult>(){

                @Override
                public Iterator<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> iterator() {
                    ArrayList<Maven31ArtifactResult> artResults = new ArrayList<Maven31ArtifactResult>(dependencyResults.getArtifactResults().size());
                    for (ArtifactResult artifactResult : dependencyResults.getArtifactResults()) {
                        artResults.add(new Maven31ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (DependencyResolutionException e) {
            throw new Maven31DependencyResolverException(e);
        }
    }
}

