/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;

public class JSFFacetPrimaryRuntimeChangedListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent event) {
        if (event instanceof IPrimaryRuntimeChangedEvent && this.getJSFFacetedVersion(event.getProject().getProject()) != null && JSFLibraryConfigurationHelper.isConfiguredForSystemSuppliedImplementation(event.getProject().getProject())) {
            try {
                IProject project = event.getProject().getProject();
                IProjectFacetVersion fv = this.getJSFFacetedVersion(project);
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            }
            catch (CoreException e) {
                JSFCorePlugin.log(4, "Unable to replace server supplied implementation when runtime changed.", e);
            }
        }
    }

    private IProjectFacetVersion getJSFFacetedVersion(IProject project) {
        return JSFAppConfigUtils.getProjectFacet(project);
    }
}

