/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.cdo.util;

import org.eclipse.emf.common.util.URI;

public class CDOURIData {
    private String server;
    private String repository;
    private String resource;

    public CDOURIData(String host, String sessionName, String resourceName) {
        this.server = host;
        this.repository = sessionName;
        this.resource = resourceName;
    }

    public String getServer() {
        return this.server;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getResource() {
        return this.resource;
    }

    public static CDOURIData parse(URI uri) {
        String server = uri.authority();
        if (server == null) {
            throw new IllegalArgumentException("missing server in URI: " + String.valueOf(uri));
        }
        String scheme = uri.scheme();
        if (!"cdo".equals(scheme)) {
            throw new IllegalArgumentException("not a cdo scheme: " + String.valueOf(uri));
        }
        String repository = uri.segment(0);
        String resource = uri.segment(1);
        return new CDOURIData(server, repository, resource);
    }
}

