/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.internal.corext.util.SearchUtils;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.internal.ui.util.StringMatcher;

public class MethodInfoFilter {
    private String fText;
    private IDLTKSearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private PatternMatcher fPackageMatcher;
    private PatternMatcher fNameMatcher;
    private static final int METHOD_MODIFIERS = 0;

    public MethodInfoFilter(String text, IDLTKSearchScope scope, int elementKind) {
        this.fText = text;
        this.fSearchScope = scope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)scope.getLanguageToolkit()));
        this.fElementKind = elementKind;
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add check here...");
        }
        this.fNameMatcher = new PatternMatcher(text, true);
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String text) {
        if (!this.fText.startsWith(text)) {
            return false;
        }
        return this.fText.indexOf(46, text.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        return this.fNameMatcher.getMatchKind() == 128;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public int getPackageFlags() {
        if (this.fPackageMatcher == null) {
            return 0;
        }
        return this.fPackageMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(MethodNameMatch method) {
        return Strings.startsWithIgnoreCase(method.getSimpleMethodName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(MethodNameMatch method) {
        if (!this.matchesPackage(method) || !this.matchesFilterExtension(method)) {
            return false;
        }
        return this.matchesName(method);
    }

    public boolean matchesHistoryElement(MethodNameMatch method) {
        if (!(this.matchesPackage(method) && this.matchesModifiers(method) && this.matchesScope(method) && this.matchesFilterExtension(method))) {
            return false;
        }
        return this.matchesName(method);
    }

    public boolean matchesFilterExtension(MethodNameMatch method) {
        return true;
    }

    private boolean matchesName(MethodNameMatch method) {
        return this.fNameMatcher.matches(method.getSimpleMethodName());
    }

    private boolean matchesPackage(MethodNameMatch method) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(method.getMethodContainerName());
    }

    private boolean matchesScope(MethodNameMatch method) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return this.fSearchScope.encloses((IModelElement)method.getMethod());
    }

    private boolean matchesModifiers(MethodNameMatch method) {
        if (this.fElementKind == 1) {
            return true;
        }
        method.getModifiers();
        boolean modifiers = false;
        switch (this.fElementKind) {
            case 1: {
                return !modifiers;
            }
        }
        return false;
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String pattern, boolean ignoreCase) {
            this(pattern, 131);
        }

        public PatternMatcher(String pattern, int allowedModes) {
            this.initializePatternAndMatchKind(pattern);
            this.fMatchKind &= allowedModes;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String text) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(text);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(text);
                }
                case 128: {
                    if (!SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) break;
                    return true;
                }
            }
            return Strings.startsWithIgnoreCase(text, this.fPattern);
        }

        private void initializePatternAndMatchKind(String pattern) {
            int length = pattern.length();
            if (length == 0) {
                this.fMatchKind = 0;
                this.fPattern = pattern;
                return;
            }
            char last = pattern.charAt(length - 1);
            if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (last) {
                    case '<': {
                        this.fPattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = pattern.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = pattern;
                        break;
                    }
                    default: {
                        this.fPattern = pattern + "*";
                    }
                }
                return;
            }
            if (last == '<') {
                this.fMatchKind = 0;
                this.fPattern = pattern.substring(0, length - 1);
                return;
            }
            if (last == ' ') {
                this.fMatchKind = 0;
                this.fPattern = pattern.trim();
                return;
            }
            if (SearchUtils.isCamelCasePattern((String)pattern)) {
                this.fMatchKind = 128;
                this.fPattern = pattern;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = pattern;
        }
    }
}

