/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.workbench.wizard;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IUIResource;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTLoader;
import org.eclipse.xwt.databinding.BindingContext;
import org.eclipse.xwt.internal.core.UIResource;

public abstract class XWTWizardPage
extends WizardPage {
    private Object dataContext;
    private BindingContext bindingContext;
    private AggregateValidationStatus validationStatus;
    private PageStateManager pageStateManager = new PageStateManager();
    private UIResource uiResource;
    private boolean xwtCaching = true;

    public boolean isXWTCaching() {
        return this.xwtCaching;
    }

    public void setXWTCaching(boolean pmfCaching) {
        this.xwtCaching = pmfCaching;
    }

    protected XWTWizardPage(String pageName, String title, ImageDescriptor titleImage, Object dataContext) {
        this(pageName, title, titleImage, dataContext, null);
    }

    protected XWTWizardPage(String pageName, String title, ImageDescriptor titleImage, Object dataContext, UIResource uiResource) {
        this(pageName, title, titleImage, dataContext, null, uiResource);
    }

    protected XWTWizardPage(String pageName, String title, ImageDescriptor titleImage, Object dataContext, BindingContext bindingContext, UIResource uiResource) {
        super(pageName, title, null);
        this.dataContext = dataContext;
        this.bindingContext = bindingContext;
        this.uiResource = uiResource;
    }

    public void createControl(Composite _parent) {
        if (this.bindingContext == null) {
            this.bindingContext = new BindingContext((Widget)_parent);
        }
        this.validationStatus = this.bindingContext.getStatus();
        this.validationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IStatus status = (IStatus)XWTWizardPage.this.validationStatus.getValue();
                if (status.getSeverity() == 4) {
                    XWTWizardPage.this.setMessage(status.getMessage(), 3);
                    XWTWizardPage.this.setPageComplete(false);
                } else {
                    XWTWizardPage.this.setMessage(status.getMessage(), status.getSeverity());
                    XWTWizardPage.this.setPageComplete(true);
                }
            }
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                BindingContext bindingContext;
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                HashMap<String, Object> newOptions = new HashMap<String, Object>();
                newOptions.put("XWT.Container", _parent);
                Object dataContext = this.getDataContext();
                if (dataContext != null) {
                    newOptions.put("XWT.DataContext", dataContext);
                }
                if ((bindingContext = this.getBindingContext()) != null) {
                    newOptions.put("XWT.BindingContext", bindingContext);
                }
                if (this.isXWTCaching()) {
                    newOptions.put(XWTLoader.XML_CACHE_PROPERTY, (Object)this);
                }
                InputStream inputStream = this.getContentInputStream();
                Object element = null;
                if (this.uiResource != null) {
                    element = XWT.loadWithOptions((IUIResource)this.uiResource, newOptions);
                } else {
                    Object object = element = inputStream == null ? XWT.loadWithOptions((URL)this.getContentURL(), newOptions) : XWT.loadWithOptions((InputStream)inputStream, (URL)this.getContentURL(), newOptions);
                }
                if (element instanceof Control) {
                    Control control = (Control)element;
                    this.setControl(control);
                    XWT.addObservableChangeListener((Object)control, (IChangeListener)this.pageStateManager);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.currentThread().setContextClassLoader(classLoader);
                _parent.setVisible(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            _parent.setVisible(true);
        }
    }

    public void dispose() {
        Control control = this.getControl();
        if (control != null) {
            XWT.removeObservableChangeListener((Object)control, (IChangeListener)this.pageStateManager);
        }
        super.dispose();
    }

    protected abstract URL getContentURL();

    protected InputStream getContentInputStream() {
        return null;
    }

    public UIResource getUIResource() {
        return this.uiResource;
    }

    public void setUIResource(UIResource uiResource) {
        this.uiResource = uiResource;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Object getDataContext() {
        return this.dataContext;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setBindingContext(BindingContext bindingContext) {
        this.bindingContext = bindingContext;
    }

    class PageStateManager
    implements IChangeListener {
        PageStateManager() {
        }

        public void handleChange(ChangeEvent event) {
            Object source = event.getSource();
            if (!(source instanceof ISWTObservable)) {
                XWTWizardPage.this.setPageComplete(false);
            }
        }
    }
}

