/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.PatternSyntaxException;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnReplace
extends Function {
    private static Collection _expected_args = null;

    public FnReplace() {
        super(new QName("replace"), 3, 4);
    }

    @Override
    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnReplace.replace(args);
    }

    public static ResultSequence replace(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnReplace.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        String str1 = "";
        if (!arg1.empty()) {
            str1 = ((XSString)arg1.first()).value();
        }
        ResultSequence arg2 = (ResultSequence)argiter.next();
        ResultSequence arg3 = (ResultSequence)argiter.next();
        ResultSequence arg4 = null;
        if (argiter.hasNext()) {
            arg4 = (ResultSequence)argiter.next();
            String flags = arg4.first().getStringValue();
            if (flags.length() == 0) {
                arg4 = null;
            } else if (!FnReplace.isFlagValid(flags)) {
                throw new DynamicError("FORX0001", "Invalid regular expression. flags");
            }
        }
        String pattern = ((XSString)arg2.first()).value();
        String replacement = ((XSString)arg3.first()).value();
        try {
            return new XSString(str1.replaceAll(pattern, replacement));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DynamicError.regex_error(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DynamicError("FORX0004", "invalid regex.");
        }
        catch (IndexOutOfBoundsException ex) {
            String className = ex.getClass().getName();
            if (className.endsWith("StringIndexOutOfBoundsException")) {
                throw new DynamicError("FORX0004", "result out of bounds");
            }
            throw new DynamicError("FORX0003", "invalid regex.");
        }
        catch (Exception exception) {
            throw new DynamicError("FORX0004", "invalid regex.");
        }
    }

    private static boolean isFlagValid(String flag) {
        char[] flags = new char[]{'s', 'm', 'i', 'x'};
        int i = 0;
        while (i < flags.length) {
            if (flag.indexOf(flags[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

