/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestAttribute;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.ui.issue.IssueSummaryPart;
import org.eclipse.mylyn.internal.github.ui.pr.CommitAttributePart;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;

public class PullRequestTaskEditorPage
extends AbstractTaskEditorPage {
    private PullRequestComposite prComp;

    public PullRequestTaskEditorPage(TaskEditor editor) {
        super(editor, "githubPullRequests");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        this.prComp = PullRequestConnector.getPullRequest((TaskData)this.getModel().getTaskData());
        Set partDescriptors = super.createPartDescriptors();
        Iterator descriptorIt = partDescriptors.iterator();
        while (descriptorIt.hasNext()) {
            TaskEditorPartDescriptor partDescriptor = (TaskEditorPartDescriptor)descriptorIt.next();
            String id = partDescriptor.getId();
            if (!id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.attributes") && !id.equals("org.eclipse.mylyn.tasks.ui.editors.parts.summary")) continue;
            descriptorIt.remove();
        }
        partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

            public AbstractTaskEditorPart createPart() {
                return new IssueSummaryPart(PullRequestAttribute.REPORTER_GRAVATAR.getMetadata().getId(), null);
            }
        }.setPath("header"));
        partDescriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                return new CommitAttributePart(PullRequestTaskEditorPage.this.prComp);
            }
        }.setPath("attachments"));
        return partDescriptors;
    }
}

