/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartCompliance;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartFormData {
    private static final Logger LOG = LoggerFactory.getLogger(MultiPartFormData.class);

    private MultiPartFormData() {
    }

    public static CompletableFuture<Parts> from(Attributes attributes, String boundary, Function<Parser, CompletableFuture<Parts>> parse) {
        return MultiPartFormData.from(attributes, MultiPartCompliance.RFC7578, ComplianceViolation.Listener.NOOP, boundary, parse);
    }

    public static CompletableFuture<Parts> from(Attributes attributes, MultiPartCompliance compliance, ComplianceViolation.Listener listener, String boundary, Function<Parser, CompletableFuture<Parts>> parse) {
        CompletableFuture<Parts> futureParts = (CompletableFuture<Parts>)attributes.getAttribute(MultiPartFormData.class.getName());
        if (futureParts == null) {
            futureParts = parse.apply(new Parser(boundary, compliance, listener));
            attributes.setAttribute(MultiPartFormData.class.getName(), futureParts);
        }
        return futureParts;
    }

    public static class Parser {
        private final PartsListener listener = new PartsListener();
        private final MultiPart.Parser parser;
        private final MultiPartCompliance compliance;
        private final ComplianceViolation.Listener complianceListener;
        private boolean useFilesForPartsWithoutFileName;
        private Path filesDirectory;
        private long maxFileSize = -1L;
        private long maxMemoryFileSize;
        private long maxLength = -1L;
        private long length;
        private Parts parts;

        public Parser(String boundary) {
            this(boundary, MultiPartCompliance.RFC7578, ComplianceViolation.Listener.NOOP);
        }

        public Parser(String boundary, MultiPartCompliance multiPartCompliance, ComplianceViolation.Listener complianceViolationListener) {
            this.compliance = Objects.requireNonNull(multiPartCompliance);
            this.complianceListener = Objects.requireNonNull(complianceViolationListener);
            this.parser = new MultiPart.Parser(Objects.requireNonNull(boundary), this.compliance, this.listener);
        }

        public CompletableFuture<Parts> parse(Content.Source content) {
            ContentSourceCompletableFuture<Parts> futureParts = new ContentSourceCompletableFuture<Parts>(content){

                protected Parts parse(Content.Chunk chunk) throws Throwable {
                    if (listener.isFailed()) {
                        throw listener.failure;
                    }
                    length += (long)chunk.getByteBuffer().remaining();
                    long max = this.getMaxLength();
                    if (max >= 0L && length > max) {
                        throw new IllegalStateException("max length exceeded: %d".formatted(max));
                    }
                    parser.parse(chunk);
                    if (listener.isFailed()) {
                        throw listener.failure;
                    }
                    return parts;
                }

                public boolean completeExceptionally(Throwable failure) {
                    boolean failed = super.completeExceptionally(failure);
                    if (failed) {
                        listener.fail(failure);
                    }
                    return failed;
                }
            };
            futureParts.parse();
            return futureParts;
        }

        public String getBoundary() {
            return this.parser.getBoundary();
        }

        public Charset getDefaultCharset() {
            return this.listener.getDefaultCharset();
        }

        public int getPartHeadersMaxLength() {
            return this.parser.getPartHeadersMaxLength();
        }

        public void setPartHeadersMaxLength(int partHeadersMaxLength) {
            this.parser.setPartHeadersMaxLength(partHeadersMaxLength);
        }

        public boolean isUseFilesForPartsWithoutFileName() {
            return this.useFilesForPartsWithoutFileName;
        }

        public void setUseFilesForPartsWithoutFileName(boolean useFilesForPartsWithoutFileName) {
            this.useFilesForPartsWithoutFileName = useFilesForPartsWithoutFileName;
        }

        public Path getFilesDirectory() {
            return this.filesDirectory;
        }

        public void setFilesDirectory(Path filesDirectory) {
            this.filesDirectory = filesDirectory;
        }

        private Path findFilesDirectory() {
            Path dir = this.getFilesDirectory();
            if (dir != null) {
                return dir;
            }
            String jettyBase = System.getProperty("jetty.base");
            if (jettyBase != null && Files.exists(dir = Path.of(jettyBase, new String[0]).resolve("work"), new LinkOption[0])) {
                return dir;
            }
            throw new IllegalArgumentException("No files directory configured");
        }

        public long getMaxFileSize() {
            return this.maxFileSize;
        }

        public void setMaxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public long getMaxMemoryFileSize() {
            return this.maxMemoryFileSize;
        }

        public void setMaxMemoryFileSize(long maxMemoryFileSize) {
            this.maxMemoryFileSize = maxMemoryFileSize;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(long maxLength) {
            this.maxLength = maxLength;
        }

        public long getMaxParts() {
            return this.parser.getMaxParts();
        }

        public void setMaxParts(long maxParts) {
            this.parser.setMaxParts(maxParts);
        }

        int getPartsSize() {
            return this.listener.getPartsSize();
        }

        private class PartsListener
        extends MultiPart.AbstractPartsListener {
            private final AutoLock lock = new AutoLock();
            private final List<MultiPart.Part> parts = new ArrayList<MultiPart.Part>();
            private final List<Content.Chunk> partChunks = new ArrayList<Content.Chunk>();
            private long fileSize;
            private long memoryFileSize;
            private Path filePath;
            private SeekableByteChannel fileChannel;
            private Throwable failure;

            private PartsListener() {
            }

            @Override
            public void onPartContent(Content.Chunk chunk) {
                ByteBuffer buffer = chunk.getByteBuffer();
                String fileName = this.getFileName();
                if (fileName != null || Parser.this.isUseFilesForPartsWithoutFileName()) {
                    long maxFileSize = Parser.this.getMaxFileSize();
                    this.fileSize += (long)buffer.remaining();
                    if (maxFileSize >= 0L && this.fileSize > maxFileSize) {
                        this.onFailure(new IllegalStateException("max file size exceeded: %d".formatted(maxFileSize)));
                        return;
                    }
                    long maxMemoryFileSize = Parser.this.getMaxMemoryFileSize();
                    if (maxMemoryFileSize >= 0L) {
                        this.memoryFileSize += (long)buffer.remaining();
                        if (this.memoryFileSize > maxMemoryFileSize) {
                            try {
                                if (this.ensureFileChannel()) {
                                    List<Content.Chunk> partChunks;
                                    try (AutoLock ignored = this.lock.lock();){
                                        partChunks = List.copyOf(this.partChunks);
                                    }
                                    for (Content.Chunk c : partChunks) {
                                        this.write(c.getByteBuffer());
                                    }
                                }
                                this.write(buffer);
                                if (chunk.isLast()) {
                                    this.close();
                                }
                            }
                            catch (Throwable x) {
                                this.onFailure(x);
                            }
                            try (AutoLock ignored = this.lock.lock();){
                                this.partChunks.forEach(Retainable::release);
                                this.partChunks.clear();
                            }
                            return;
                        }
                    }
                }
                chunk.retain();
                try (AutoLock ignored = this.lock.lock();){
                    this.partChunks.add(chunk);
                }
            }

            private void write(ByteBuffer buffer) throws Exception {
                int written;
                for (int remaining = buffer.remaining(); remaining > 0; remaining -= written) {
                    SeekableByteChannel channel = this.fileChannel();
                    if (channel == null) {
                        throw new IllegalStateException();
                    }
                    written = channel.write(buffer);
                    if (written != 0) continue;
                    throw new NonWritableChannelException();
                }
            }

            private void close() {
                try {
                    SeekableByteChannel closeable = this.fileChannel();
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable x) {
                    this.onFailure(x);
                }
            }

            @Override
            public void onPart(String name, String fileName, HttpFields headers) {
                this.fileSize = 0L;
                this.memoryFileSize = 0L;
                try (AutoLock ignored = this.lock.lock();){
                    String value = headers.get(HttpHeader.CONTENT_TRANSFER_ENCODING);
                    if (value != null) {
                        switch (StringUtil.asciiToLowerCase((String)value)) {
                            case "base64": {
                                Parser.this.complianceListener.onComplianceViolation(new ComplianceViolation.Event(Parser.this.compliance, MultiPartCompliance.Violation.BASE64_TRANSFER_ENCODING, value));
                                break;
                            }
                            case "quoted-printable": {
                                Parser.this.complianceListener.onComplianceViolation(new ComplianceViolation.Event(Parser.this.compliance, MultiPartCompliance.Violation.QUOTED_PRINTABLE_TRANSFER_ENCODING, value));
                                break;
                            }
                            case "8bit": 
                            case "binary": {
                                break;
                            }
                            default: {
                                Parser.this.complianceListener.onComplianceViolation(new ComplianceViolation.Event(Parser.this.compliance, MultiPartCompliance.Violation.CONTENT_TRANSFER_ENCODING, value));
                            }
                        }
                    }
                    MultiPart.Part part = this.fileChannel != null ? new MultiPart.PathPart(name, fileName, headers, this.filePath) : new MultiPart.ChunksPart(name, fileName, headers, List.copyOf(this.partChunks));
                    this.filePath = null;
                    this.fileChannel = null;
                    this.partChunks.forEach(Retainable::release);
                    this.partChunks.clear();
                    this.parts.add(part);
                }
            }

            @Override
            public void onComplete() {
                super.onComplete();
                try (AutoLock ignored = this.lock.lock();){
                    List<MultiPart.Part> result = List.copyOf(this.parts);
                    Parser.this.parts = new Parts(result);
                }
            }

            Charset getDefaultCharset() {
                try (AutoLock ignored = this.lock.lock();){
                    Charset charset = this.parts.stream().filter(part -> "_charset_".equals(part.getName())).map(part -> part.getContentAsString(StandardCharsets.US_ASCII)).map(Charset::forName).findFirst().orElse(null);
                    return charset;
                }
            }

            int getPartsSize() {
                try (AutoLock ignored = this.lock.lock();){
                    int n = this.parts.size();
                    return n;
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                this.fail(failure);
            }

            @Override
            public void onViolation(MultiPartCompliance.Violation violation) {
                block2: {
                    try {
                        ComplianceViolation.Event event = new ComplianceViolation.Event(Parser.this.compliance, violation, "multipart spec violation");
                        Parser.this.complianceListener.onComplianceViolation(event);
                    }
                    catch (Throwable x) {
                        if (!LOG.isDebugEnabled()) break block2;
                        LOG.debug("failure while notifying listener {}", (Object)Parser.this.complianceListener, (Object)x);
                    }
                }
            }

            private void fail(Throwable cause) {
                List<MultiPart.Part> partsToFail;
                try (AutoLock ignored = this.lock.lock();){
                    if (this.failure != null) {
                        return;
                    }
                    this.failure = cause;
                    partsToFail = List.copyOf(this.parts);
                    this.parts.clear();
                    this.partChunks.forEach(Retainable::release);
                    this.partChunks.clear();
                }
                partsToFail.forEach(p -> p.fail(cause));
                this.close();
                this.delete();
            }

            private SeekableByteChannel fileChannel() {
                try (AutoLock ignored = this.lock.lock();){
                    SeekableByteChannel seekableByteChannel = this.fileChannel;
                    return seekableByteChannel;
                }
            }

            private void delete() {
                block11: {
                    try {
                        Path path = null;
                        try (AutoLock ignored = this.lock.lock();){
                            if (this.filePath != null) {
                                path = this.filePath;
                            }
                            this.filePath = null;
                            this.fileChannel = null;
                        }
                        if (path != null) {
                            Files.delete(path);
                        }
                    }
                    catch (Throwable x) {
                        if (!LOG.isTraceEnabled()) break block11;
                        LOG.trace("IGNORED", x);
                    }
                }
            }

            private boolean isFailed() {
                try (AutoLock ignored = this.lock.lock();){
                    boolean bl = this.failure != null;
                    return bl;
                }
            }

            private boolean ensureFileChannel() {
                try (AutoLock ignored = this.lock.lock();){
                    if (this.fileChannel != null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.createFileChannel();
                    boolean bl = true;
                    return bl;
                }
            }

            private void createFileChannel() {
                try (AutoLock ignored = this.lock.lock();){
                    Path directory = Parser.this.findFilesDirectory();
                    Files.createDirectories(directory, new FileAttribute[0]);
                    String fileName = "MultiPart";
                    this.filePath = Files.createTempFile(directory, fileName, "", new FileAttribute[0]);
                    this.fileChannel = Files.newByteChannel(this.filePath, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
                }
                catch (Throwable x) {
                    this.onFailure(x);
                }
            }
        }
    }

    public static class ContentSource
    extends MultiPart.AbstractContentSource {
        public ContentSource(String boundary) {
            super(boundary);
        }

        @Override
        protected HttpFields customizePartHeaders(MultiPart.Part part) {
            String fileName;
            HttpFields headers = super.customizePartHeaders(part);
            if (headers.contains(HttpHeader.CONTENT_DISPOSITION)) {
                return headers;
            }
            Object value = "form-data";
            String name = part.getName();
            if (name != null) {
                value = (String)value + "; name=" + QuotedCSV.quote(name);
            }
            if ((fileName = part.getFileName()) != null) {
                value = (String)value + "; filename=" + QuotedCSV.quote(fileName);
            }
            return HttpFields.build(headers).put(HttpHeader.CONTENT_DISPOSITION, (String)value);
        }
    }

    public static class Parts
    implements Iterable<MultiPart.Part>,
    Closeable {
        private final List<MultiPart.Part> parts;

        private Parts(List<MultiPart.Part> parts) {
            this.parts = parts;
        }

        public MultiPart.Part get(int index) {
            return this.parts.get(index);
        }

        public MultiPart.Part getFirst(String name) {
            return this.parts.stream().filter(part -> part.getName().equals(name)).findFirst().orElse(null);
        }

        public List<MultiPart.Part> getAll(String name) {
            return this.parts.stream().filter(part -> part.getName().equals(name)).toList();
        }

        public int size() {
            return this.parts.size();
        }

        @Override
        public Iterator<MultiPart.Part> iterator() {
            return this.parts.iterator();
        }

        @Override
        public void close() {
            for (MultiPart.Part p : this.parts) {
                IO.close((Closeable)p);
            }
        }
    }
}

