/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalScoreFunction;
import org.apache.lucene.queries.intervals.IntervalScorer;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;
    private final IntervalScoreFunction scoreFunction;

    public IntervalQuery(String field, IntervalsSource intervalsSource) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(1.0f));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(pivot));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot, float exp) {
        this(field, intervalsSource, IntervalScoreFunction.sigmoidFunction(pivot, exp));
    }

    private IntervalQuery(String field, IntervalsSource intervalsSource, IntervalScoreFunction scoreFunction) {
        Objects.requireNonNull(field, "null field aren't accepted");
        Objects.requireNonNull(intervalsSource, "null intervalsSource aren't accepted");
        Objects.requireNonNull(scoreFunction, "null searchStrategy aren't accepted");
        this.field = field;
        this.intervalsSource = intervalsSource;
        this.scoreFunction = scoreFunction;
    }

    public String getField() {
        return this.field;
    }

    public String toString(String field) {
        return (String)(!this.getField().equals(field) ? this.getField() + ":" : "") + this.intervalsSource.toString();
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new IntervalWeight(this, boost);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.intervalsSource.visit(this.field, visitor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)((Object)o);
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final float boost;

        public IntervalWeight(Query query, float boost) {
            super(query);
            this.boost = boost;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.freq();
                return IntervalQuery.this.scoreFunction.explain(IntervalQuery.this.toString(), this.boost, freq);
            }
            return Explanation.noMatch((String)"no matching intervals", (Explanation[])new Explanation[0]);
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return MatchesUtils.forField((String)IntervalQuery.this.field, () -> {
                IntervalMatchesIterator mi = IntervalQuery.this.intervalsSource.matches(IntervalQuery.this.field, context, doc);
                if (mi == null) {
                    return null;
                }
                return new FilterMatchesIterator(mi){

                    public Query getQuery() {
                        return new IntervalQuery(IntervalQuery.this.field, IntervalQuery.this.intervalsSource);
                    }
                };
            });
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            return new IntervalScorer(this, intervals, IntervalQuery.this.intervalsSource.minExtent(), this.boost, IntervalQuery.this.scoreFunction);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

