/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandCallback;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParams;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.WipParamsWithResponse;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class WipRelayRunner {
    public static <RES> Step<RES> createFinalStep(final RES finalResult) {
        return new Step<RES>(){

            @Override
            public <R> R accept(Step.Visitor<R, RES> visitor) {
                return visitor.visitFinal(finalResult);
            }
        };
    }

    public static <RES> RelayOk run(final WipCommandProcessor commandProcessor, Step<RES> firstStep, final GenericCallback<RES> callback, final RelaySyncCallback relaySyncCallback) {
        return (RelayOk)firstStep.accept(new Step.Visitor<RelayOk, RES>(){

            @Override
            public RelayOk visitFinal(RES finalResult) {
                if (callback != null) {
                    callback.success(finalResult);
                }
                return relaySyncCallback.finish();
            }

            @Override
            public RelayOk visitSend(final SendStepSimple<RES> sendStep) {
                final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
                WipCommandCallback sendCallback = new WipCommandCallback(){

                    public void messageReceived(WipCommandResponse response) {
                        Step processResult;
                        try {
                            processResult = sendStep.processResponse();
                        }
                        catch (ProcessException e) {
                            if (callback != null) {
                                callback.failure((Exception)e);
                            }
                            return;
                        }
                        RelayOk relayOk = WipRelayRunner.run(commandProcessor, processResult, callback, guard.getRelay());
                        guard.discharge(relayOk);
                    }

                    public void failure(String message) {
                        if (callback != null) {
                            callback.failure(sendStep.processFailure(new Exception(message)));
                        }
                    }
                };
                return commandProcessor.send(sendStep.getParams(), sendCallback, guard.asSyncCallback());
            }

            @Override
            public <RESPONSE> RelayOk visitSend(final SendStepWithResponse<RESPONSE, RES> sendStep) {
                final RelaySyncCallback.Guard guard = relaySyncCallback.newGuard();
                GenericCallback sendCallback = new GenericCallback<RESPONSE>(){

                    public void success(RESPONSE response) {
                        Step processResult;
                        try {
                            processResult = sendStep.processResponse(response);
                        }
                        catch (ProcessException e) {
                            if (callback != null) {
                                callback.failure((Exception)e);
                            }
                            return;
                        }
                        RelayOk relayOk = WipRelayRunner.run(commandProcessor, processResult, callback, guard.getRelay());
                        guard.discharge(relayOk);
                    }

                    public void failure(Exception exception) {
                        if (callback != null) {
                            callback.failure(sendStep.processFailure(exception));
                        }
                    }
                };
                return commandProcessor.send(sendStep.getParams(), sendCallback, guard.asSyncCallback());
            }
        });
    }

    public static class ProcessException
    extends Exception {
        public ProcessException() {
        }

        public ProcessException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProcessException(String message) {
            super(message);
        }

        public ProcessException(Throwable cause) {
            super(cause);
        }
    }

    public static abstract class SendStepSimple<RES>
    implements Step<RES> {
        public abstract WipParams getParams();

        public abstract Step<RES> processResponse() throws ProcessException;

        public abstract Exception processFailure(Exception var1);

        @Override
        public final <R> R accept(Step.Visitor<R, RES> visitor) {
            return visitor.visitSend(this);
        }
    }

    public static abstract class SendStepWithResponse<DATA, RES>
    implements Step<RES> {
        public abstract WipParamsWithResponse<DATA> getParams();

        public abstract Step<RES> processResponse(DATA var1) throws ProcessException;

        public abstract Exception processFailure(Exception var1);

        @Override
        public final <R> R accept(Step.Visitor<R, RES> visitor) {
            return visitor.visitSend(this);
        }
    }

    static interface Step<RES> {
        public <R> R accept(Visitor<R, RES> var1);

        public static interface Visitor<R, RES> {
            public R visitFinal(RES var1);

            public R visitSend(SendStepSimple<RES> var1);

            public <DATA> R visitSend(SendStepWithResponse<DATA, RES> var1);
        }
    }
}

