/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views;

import java.util.BitSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.event.IPDebugErrorInfo;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.debug.core.event.IPDebugRegisterInfo;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.internal.debug.core.PDebugOptions;
import org.eclipse.ptp.internal.debug.ui.PDebugUIUtils;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.UIDebugManager;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.debug.ui.views.AbstractPDebugViewEventHandler;
import org.eclipse.ptp.internal.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ui.IViewPart;

public class ParallelDebugViewEventHandler
extends AbstractPDebugViewEventHandler {
    private long time_record = 0L;

    public ParallelDebugViewEventHandler(ParallelDebugView view) {
        super((IViewPart)view);
    }

    public ParallelDebugView getPView() {
        return (ParallelDebugView)this.getView();
    }

    public void refresh(boolean all) {
        if (this.getPView().isVisible()) {
            this.getPView().refresh(all);
        }
    }

    protected void doHandleDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
        IPDebugInfo info = event.getInfo();
        String jobId = info.getLaunch().getJobId();
        block0 : switch (event.getKind()) {
            case 4: {
                switch (event.getDetail()) {
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        int[] c_regTask_array = info.getAllTasks().toArray();
                        if (refresh) {
                            IElementHandler elementHandler = this.getPView().getElementHandler(jobId);
                            if (elementHandler != null) {
                                elementHandler.register((BitSet)info.getAllTasks());
                            }
                            this.refresh();
                        }
                        if (c_regTask_array.length <= 0) break block0;
                        this.getPView().focusOnDebugTarget(jobId, c_regTask_array[0]);
                        break block0;
                    }
                    case 1024: {
                        IJobStatus job = JobManager.getInstance().getJob(info.getLaunch().getJobControl().getControlId(), jobId);
                        if (job == null) break block0;
                        this.getPView().changeJobRefresh(job);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                IElementHandler elementHandler = this.getPView().getElementHandler(jobId);
                switch (event.getDetail()) {
                    case 1024: {
                        if (elementHandler != null) {
                            elementHandler.removeAllRegistered();
                        }
                        this.refresh(true);
                        break block0;
                    }
                    case 2048: {
                        boolean refresh = true;
                        if (info instanceof IPDebugRegisterInfo) {
                            refresh = ((IPDebugRegisterInfo)info).isRefresh();
                        }
                        if (!refresh) break block0;
                        if (elementHandler != null) {
                            elementHandler.unRegister((BitSet)info.getAllTasks());
                        }
                        this.refresh();
                        break block0;
                    }
                    case 16: {
                        break block0;
                    }
                    case 32: {
                        UIDebugManager uiMgr = (UIDebugManager)this.getPView().getUIManager();
                        IPSession session = uiMgr.getDebugSession(jobId);
                        if (session != null) {
                            uiMgr.unregisterTasks(session, info.getAllRegisteredTasks());
                        }
                        this.refresh(true);
                        break block0;
                    }
                }
                this.refresh(true);
                break;
            }
            case 1: {
                this.time_record = System.currentTimeMillis();
                PDebugOptions.trace((String)("================= TIME RESUME: " + this.time_record));
                this.refresh(true);
                break;
            }
            case 2: {
                int[] processes;
                IPSession s = ((UIDebugManager)this.getPView().getUIManager()).getDebugSession(jobId);
                if (s != null && s.getTasks().cardinality() == s.getPDISession().getTaskManager().getSuspendedTasks().cardinality()) {
                    PDebugOptions.trace((String)("================= TIME ALL SUSPENDED: " + (System.currentTimeMillis() - this.time_record)));
                    this.time_record = System.currentTimeMillis();
                }
                if ((processes = info.getAllRegisteredTasks().toArray()).length > 0) {
                    this.getPView().focusOnDebugTarget(jobId, processes[0]);
                }
                this.refresh(true);
                break;
            }
            case 16: {
                switch (event.getDetail()) {
                    case 32: {
                        IPSession session;
                        UIDebugManager uiMgr = (UIDebugManager)this.getPView().getUIManager();
                        if (!uiMgr.isEnabledDefaultRegister() || (session = uiMgr.getDebugSession(jobId)) == null) break block0;
                        uiMgr.registerTasks(session, session.getTasks(0));
                        break block0;
                    }
                }
                break;
            }
            case 64: {
                final IPDebugErrorInfo errInfo = (IPDebugErrorInfo)info;
                if (event.getDetail() == 1) break;
                PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        String msg = NLS.bind((String)Messages.ParallelDebugViewEventHandler_2, (Object[])new Object[]{PDebugUIUtils.showBitList(errInfo.getAllTasks()), errInfo.getMsg(), errInfo.getDetailsMsg()});
                        Status status = new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, msg, null);
                        PTPDebugUIPlugin.errorDialog(Messages.ParallelDebugViewEventHandler_3, (IStatus)status);
                    }
                });
                if (event.getDetail() != 4) break;
                IElementHandler eHandler = this.getPView().getElementHandler(jobId);
                if (eHandler != null) {
                    eHandler.unRegister((BitSet)info.getAllRegisteredTasks());
                }
                this.refresh(true);
            }
        }
    }

    private String getProcessId(IPLaunch launch, int task) {
        return Integer.toString(task);
    }
}

