/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.AbstractRenameProcessor;
import org.eclipse.php.refactoring.core.rename.ITextUpdating;
import org.eclipse.php.refactoring.core.rename.logic.RenameLocalVariable;

public class RenameLocalVariableProcessor
extends AbstractRenameProcessor<IFile>
implements ITextUpdating {
    private static final String RENAME_IS_PROCESSING = PHPRefactoringCoreMessages.getString("RenameLocalVariableProcessor.0");
    private static final String CREATING_MODIFICATIONS_LABEL = PHPRefactoringCoreMessages.getString("RenameLocalVariableProcessor.1");
    private static final String LOCAL_VARIABLE_IS_USED = PHPRefactoringCoreMessages.getString("RenameLocalVariableProcessor.2");
    private static final String ID_RENAME_FUNCTION = "php.refactoring.ui.rename.localVariable";
    protected static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final String RENAME_FUNCTION_PROCESSOR_NAME = PHPRefactoringCoreMessages.getString("RenameLocalVariableProcessor.3");
    private final Variable identifier;
    private boolean isUpdateTextualMatches;
    private final FunctionDeclaration functionDeclaration;

    public RenameLocalVariableProcessor(IFile operatedFile, ASTNode locateNode) {
        super(operatedFile);
        this.identifier = locateNode instanceof Identifier ? (Variable)locateNode.getParent() : (Variable)locateNode;
        ASTNode parent = this.identifier.getParent();
        while (parent.getType() != 29) {
            parent = parent.getParent();
        }
        assert (parent.getType() == 29);
        this.functionDeclaration = (FunctionDeclaration)parent;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(RENAME_IS_PROCESSING, this.participantFiles.size());
            pm.setTaskName(CREATING_MODIFICATIONS_LABEL);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            String newElementName = this.getNewElementName();
            RenameLocalVariable rename = new RenameLocalVariable((IFile)this.resource, ((Identifier)this.identifier.getName()).getName(), newElementName, this.getUpdateTextualMatches());
            this.functionDeclaration.accept((Visitor)rename);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            pm.worked(1);
            TextFileChange change = null;
            if (rename.hasChanges()) {
                change = this.acquireChange((IFile)this.resource, this.getProgram((ASTNode)this.functionDeclaration));
                rename.updateChange(change);
            }
            TextFileChange textFileChange = change;
            return textFileChange;
        }
        finally {
            pm.done();
        }
    }

    private Program getProgram(ASTNode node) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node.getType() == 46 ? (Program)node : null;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.identifier};
    }

    public String getIdentifier() {
        return ID_RENAME_FUNCTION;
    }

    public String getProcessorName() {
        return RENAME_FUNCTION_PROCESSOR_NAME;
    }

    @Override
    public Object getNewElement() {
        return this.getNewElementName();
    }

    @Override
    public String getCurrentElementName() {
        return ((Identifier)this.identifier.getName()).getName();
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public String getCurrentElementQualifier() {
        return ((Identifier)this.identifier.getName()).getName();
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.isUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.isUpdateTextualMatches = update;
    }

    @Override
    public RefactoringStatus getRefactoringStatus(IFile key, Program program) {
        if (PHPElementConciliator.localVariableAlreadyExists((FunctionDeclaration)this.functionDeclaration, (String)this.getNewElementName())) {
            String message = MessageFormat.format(LOCAL_VARIABLE_IS_USED, ((IFile)this.resource).getName());
            return RefactoringStatus.createWarningStatus((String)message);
        }
        return null;
    }
}

