/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.conversion.IProjectConversionEnabler;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenArtifactComponent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class MavenPomWizardPage
extends AbstractMavenWizardPage {
    private Text projectText;
    private final ISelection selection;
    private MavenArtifactComponent pomComponent;
    private IProjectConversionEnabler projectConversionEnabler;

    public MavenPomWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.MavenPomWizardPage_title);
        this.setDescription(Messages.MavenPomWizardPage_desc);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)layout);
        ModifyListener modifyingListener = e -> this.dialogChanged();
        Label label = new Label(container, 0);
        label.setText(Messages.MavenPomWizardPage_lblProject);
        this.projectText = new Text(container, 2060);
        this.projectText.setEditable(false);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(modifyingListener);
        this.pomComponent = new MavenArtifactComponent(container, 0);
        this.pomComponent.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.pomComponent.setModifyingListener(modifyingListener);
        this.addFieldWithHistory("groupId", this.pomComponent.getGroupIdCombo());
        this.addFieldWithHistory("artifactId", this.pomComponent.getArtifactIdCombo());
        this.addFieldWithHistory("version", this.pomComponent.getVersionCombo());
        this.addFieldWithHistory("name", this.pomComponent.getNameCombo());
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        String packagingToUse = "jar";
        List availablePackagingTypes = Arrays.asList(MavenArtifactComponent.PACKAGING_OPTIONS);
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection var3_4) {
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource var6_7) {
                 instanceOfPatternExpressionValue = obj;
                IContainer container =  instanceOfPatternExpressionValue instanceof IContainer && (var9_9 = (IContainer) instanceOfPatternExpressionValue) == (IContainer) instanceOfPatternExpressionValue ? c : resource.getParent();
                this.projectText.setText(container.getFullPath().toString());
                this.pomComponent.setArtifactId(container.getName());
                this.pomComponent.setGroupId(container.getName());
                if (container instanceof IProject var11_12) {
                    IProjectConversionManager pcm = MavenPlugin.getProjectConversionManager();
                    this.projectConversionEnabler = pcm.getConversionEnablerForProject((IProject)project);
                    if (this.projectConversionEnabler != null) {
                        availablePackagingTypes = this.projectConversionEnabler.getPackagingTypes((IProject)project);
                        packagingToUse = (String)availablePackagingTypes.get(0);
                    }
                }
            }
        }
        this.pomComponent.setVersion("0.0.1-SNAPSHOT");
        this.pomComponent.setPackagingTypes(availablePackagingTypes);
        this.pomComponent.setPackaging(packagingToUse);
        this.pomComponent.setFocus();
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.MavenPomWizardPage_dialog_title);
        dialog.showClosedProjects(false);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.projectText.setText(((Path)result[0]).toString());
        }
    }

    void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getProject()));
        if (this.getProject().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder);
            return;
        }
        if (container == null || (container.getType() & 2 | 4) == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder2);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.MavenPomWizardPage_error_folder_write);
            return;
        }
        String message = this.validateGroupIdInput(this.pomComponent.getGroupId());
        if (message != null) {
            this.updateStatus(message);
            return;
        }
        message = this.validateArtifactIdInput(this.pomComponent.getArtifactId());
        if (message != null) {
            this.updateStatus(message);
            return;
        }
        if (this.pomComponent.getVersion().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_version);
            return;
        }
        if (this.pomComponent.getPackaging().length() == 0) {
            this.updateStatus(Messages.MavenPomWizardPage_error_pack);
            return;
        }
        if (container instanceof IProject var3_4 && this.projectConversionEnabler != null && (status = this.projectConversionEnabler.canBeConverted((IProject)project)).getSeverity() == 4) {
            this.updateStatus(status.getMessage());
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getProject() {
        return this.projectText.getText();
    }

    public Model getModel() {
        return this.pomComponent.getModel();
    }
}

