/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Gravity implements Enumerator
{
    SOUTH(0, "SOUTH", "Not-Rotated"),
    NORTH(1, "NORTH", "Upside-Down"),
    EAST(2, "EAST", "Rotated-Left"),
    WEST(3, "WEST", "Rotated-Right");

    public static final int SOUTH_VALUE = 0;
    public static final int NORTH_VALUE = 1;
    public static final int EAST_VALUE = 2;
    public static final int WEST_VALUE = 3;
    private static final Gravity[] VALUES_ARRAY;
    public static final List<Gravity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Gravity[]{SOUTH, NORTH, EAST, WEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Gravity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gravity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gravity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Gravity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Gravity get(int value) {
        switch (value) {
            case 0: {
                return SOUTH;
            }
            case 1: {
                return NORTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return WEST;
            }
        }
        return null;
    }

    private Gravity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

