/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.qvt.oml.debug.core.IQVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugElement;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.Value;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDetailRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDetailResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMVariableRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMVariableResponse;

public class QVTOValue
extends QVTODebugElement
implements IValue {
    final VMVariable vmVar;
    private Value vmValue;
    private long frameID;

    QVTOValue(IQVTODebugTarget debugTarget, VMVariable vmVar, long frameID) {
        super(debugTarget);
        this.vmVar = vmVar;
        this.vmValue = vmVar.value;
        this.frameID = frameID;
    }

    public boolean hasVariables() throws DebugException {
        return this.vmValue != null && this.vmValue.hasVariables;
    }

    public IVariable[] getVariables() throws DebugException {
        List<VMVariable> variables = this.requestVariables();
        ArrayList<QVTOVariable> result = new ArrayList<QVTOVariable>();
        for (VMVariable nextVar : variables) {
            result.add(new QVTOVariable(this.getQVTODebugTarget(), nextVar, this.frameID));
        }
        return result.toArray(new IVariable[result.size()]);
    }

    public String getValueString() throws DebugException {
        return this.vmValue != null ? String.valueOf(this.vmValue.value) : "null";
    }

    public String getReferenceTypeName() throws DebugException {
        return this.vmVar.type.actualType;
    }

    public String computeDetail() throws DebugException {
        URI varURI = URI.createURI((String)this.getVariableURIForVMRequest());
        VMDetailRequest request = new VMDetailRequest(varURI);
        VMResponse response = this.getQVTODebugTarget().sendRequest(request);
        if (response instanceof VMDetailResponse) {
            VMDetailResponse detailResponse = (VMDetailResponse)response;
            return detailResponse.getDetail();
        }
        return "";
    }

    private String getVariableURIForVMRequest() {
        String variableURI = this.vmVar.name;
        if (!this.vmVar.isRootVariable()) {
            variableURI = this.vmVar.variableURI;
        }
        return variableURI;
    }

    List<VMVariable> requestVariables() throws DebugException {
        String variableURI = this.getVariableURIForVMRequest();
        VMVariableRequest request = new VMVariableRequest(this.frameID, variableURI, true);
        VMResponse response = this.getQVTODebugTarget().sendRequest(request);
        if (response instanceof VMVariableResponse) {
            VMVariableResponse variableResponse = (VMVariableResponse)response;
            if (variableResponse.childVariables != null) {
                return Arrays.asList(variableResponse.childVariables);
            }
        }
        return Collections.emptyList();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }
}

