/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.unittest.internal.model.UnitTestLaunchListener;
import org.eclipse.unittest.internal.model.UnitTestModel;
import org.eclipse.unittest.internal.ui.history.History;
import org.osgi.framework.BundleContext;

public class UnitTestPlugin
extends AbstractUIPlugin {
    private static UnitTestPlugin fgPlugin = null;
    private final ILaunchListener fLaunchListener = new UnitTestLaunchListener();
    public static final String PLUGIN_ID = "org.eclipse.unittest.ui";

    public UnitTestPlugin() {
        fgPlugin = this;
    }

    public static UnitTestPlugin getDefault() {
        return fgPlugin;
    }

    public static void log(Throwable e) {
        UnitTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public static void log(IStatus status) {
        UnitTestPlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UnitTestModel.getInstance().start();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchListener);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).flush();
            UnitTestModel.getInstance().stop();
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchListener);
            History.INSTANCE.clear();
        }
        finally {
            super.stop(context);
        }
    }
}

