/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class CacheManager {
    public static final char PATH_ESCAPE_CHAR = '$';

    public static IPath getCachePath(IFSTreeNode node) {
        File location = CacheManager.getCacheRoot();
        String agentId = node.getRuntimeModel().getPeerNode().getPeerId();
        String agent = agentId.replace(':', '$');
        IPath agentDir = new Path(location.getAbsolutePath()).append(agent);
        File agentDirFile = agentDir.toFile();
        CacheManager.mkdirChecked(agentDirFile);
        return CacheManager.appendNodePath(agentDir, node);
    }

    static void mkdirChecked(final File dir) {
        if (!dir.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!dir.mkdirs()) {
                        throw new Exception(NLS.bind((String)Messages.CacheManager_MkdirFailed, (Object)dir.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    static void setReadOnlyChecked(final File file) {
        if (file.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!file.setReadOnly()) {
                        throw new Exception(NLS.bind((String)Messages.CacheManager_SetReadOnlyFailed, (Object)file.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    public static File getCacheFile(IFSTreeNode node) {
        return CacheManager.getCachePath(node).toFile();
    }

    public static File getCacheRoot() {
        File location;
        try {
            location = CorePlugin.getDefault().getStateLocation().toFile();
        }
        catch (IllegalStateException e) {
            location = new File(System.getProperty("user.home"), ".tcf");
            location = new File(location, "fs");
        }
        CacheManager.mkdirChecked(location);
        return location;
    }

    private static IPath appendNodePath(IPath path, IFSTreeNode node) {
        if (!node.isRootDirectory() && node.getParent() != null) {
            path = CacheManager.appendNodePath(path, node.getParent());
            return CacheManager.appendPathSegment(node, path, node.getName());
        }
        String name = node.getName();
        if (node.isWindowsNode()) {
            name = name.replace('\\', '/');
        }
        if ((name = name.replace(':', '$')).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return CacheManager.appendPathSegment(node, path, name);
    }

    private static IPath appendPathSegment(IFSTreeNode node, IPath path, String name) {
        IPath newPath = path.append(name);
        File newFile = newPath.toFile();
        if (node.isDirectory()) {
            CacheManager.mkdirChecked(newFile);
        }
        return newPath;
    }

    public static void clearCache(FSTreeNode source) {
        File cache;
        if (source != null && (cache = CacheManager.getCacheFile(source)).exists()) {
            CacheManager.deleteFileOrDir(cache);
        }
    }

    private static boolean deleteFileOrDir(File file) {
        File[] children = file.listFiles();
        boolean ok = true;
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (!CacheManager.deleteFileOrDir(child)) {
                    ok = false;
                }
                ++n2;
            }
        }
        return ok && file.delete();
    }
}

