/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.qmltypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLEnumInfo;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLExportInfo;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLMethodInfo;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLModelBuilder;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLPropertyInfo;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLSignalInfo;
import org.eclipse.cdt.qt.core.qmljs.IQmlObjectDefinition;
import org.eclipse.cdt.qt.core.qmljs.IQmlObjectMember;
import org.eclipse.cdt.qt.core.qmljs.IQmlPropertyBinding;

public class QMLComponentInfo {
    static final String IDENTIFIER = "Component";
    static final String PROPERTY_NAME = "name";
    static final String PROPERTY_PROTOTYPE = "prototype";
    static final String PROPERTY_DEF_PROPERTY = "defaultProperty";
    static final String PROPERTY_ATTACHED_TYPE = "attachedType";
    static final String PROPERTY_EXPORTS = "exports";
    static final String PROPERTY_EXPORT_REVISIONS = "exportMetaObjectRevisions";
    private String name;
    private String prototype;
    private String defaultProperty;
    private String attachedType;
    private Integer[] exportMetaObjectRevisions;
    private List<QMLExportInfo> exportList = new ArrayList<QMLExportInfo>();
    private List<QMLPropertyInfo> propertyList = new ArrayList<QMLPropertyInfo>();
    private List<QMLMethodInfo> methodList = new ArrayList<QMLMethodInfo>();
    private List<QMLSignalInfo> signalList = new ArrayList<QMLSignalInfo>();
    private List<QMLEnumInfo> enumList = new ArrayList<QMLEnumInfo>();

    protected QMLComponentInfo(QMLModelBuilder builder, IQmlObjectDefinition obj) {
        builder.ensureIdentifier(obj.getIdentifier(), IDENTIFIER);
        block28: for (IQmlObjectMember member : obj.getBody().getMembers()) {
            block42: {
                block40: {
                    if (!(member instanceof IQmlPropertyBinding)) break block40;
                    IQmlPropertyBinding prop = (IQmlPropertyBinding)member;
                    switch (prop.getIdentifier().getName()) {
                        case "name": {
                            this.name = builder.getStringBinding(prop);
                            break;
                        }
                        case "prototype": {
                            this.prototype = builder.getStringBinding(prop);
                            break;
                        }
                        case "defaultProperty": {
                            this.defaultProperty = builder.getStringBinding(prop);
                            break;
                        }
                        case "attachedType": {
                            this.attachedType = builder.getStringBinding(prop);
                            break;
                        }
                        case "exports": {
                            String[] exports;
                            String[] stringArray = exports = builder.getStringArrayBinding(prop);
                            int n = exports.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String exp = stringArray[n2];
                                this.exportList.add(new QMLExportInfo(builder, exp));
                                ++n2;
                            }
                            continue block28;
                        }
                        case "exportMetaObjectRevisions": {
                            this.exportMetaObjectRevisions = builder.getIntegerArrayBinding(prop);
                        }
                    }
                    continue;
                }
                if (!(member instanceof IQmlObjectDefinition)) break block42;
                IQmlObjectDefinition object = (IQmlObjectDefinition)member;
                switch (object.getIdentifier().getName()) {
                    case "Property": {
                        this.propertyList.add(new QMLPropertyInfo(builder, object));
                        break;
                    }
                    case "Method": {
                        this.methodList.add(new QMLMethodInfo(builder, object));
                        break;
                    }
                    case "Signal": {
                        this.signalList.add(new QMLSignalInfo(builder, object));
                        break;
                    }
                    case "Enum": {
                        this.enumList.add(new QMLEnumInfo(builder, object));
                    }
                }
                continue;
            }
            builder.unexpectedNode(member);
        }
        this.exportList = Collections.unmodifiableList(this.exportList);
        this.propertyList = Collections.unmodifiableList(this.propertyList);
        this.methodList = Collections.unmodifiableList(this.methodList);
        this.signalList = Collections.unmodifiableList(this.signalList);
        this.enumList = Collections.unmodifiableList(this.enumList);
    }

    public String getName() {
        return this.name;
    }

    public String getPrototype() {
        return this.prototype;
    }

    public String getDefaultProperty() {
        return this.defaultProperty;
    }

    public String getAttachedType() {
        return this.attachedType;
    }

    public List<QMLExportInfo> getExports() {
        return this.exportList;
    }

    public Integer[] getExportMetaObjectRevisions() {
        return Arrays.copyOf(this.exportMetaObjectRevisions, this.exportMetaObjectRevisions.length);
    }

    public List<QMLPropertyInfo> getProperties() {
        return this.propertyList;
    }

    public List<QMLMethodInfo> getMethods() {
        return this.methodList;
    }

    public List<QMLSignalInfo> getSignals() {
        return this.signalList;
    }

    public List<QMLEnumInfo> getEnums() {
        return this.enumList;
    }
}

