/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import java.io.File;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.mat.ui.internal.query.arguments.BooleanComboEditor;
import org.eclipse.mat.ui.internal.query.arguments.EnumComboEditor;
import org.eclipse.mat.ui.internal.query.arguments.FileOpenDialogEditor;
import org.eclipse.mat.ui.internal.query.arguments.SnapshotSelectionEditor;
import org.eclipse.mat.ui.internal.query.arguments.TextEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class TableEditorFactory {
    public static ArgumentEditor createTableEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        if (descriptor.isBoolean()) {
            return new BooleanComboEditor(parent, context, descriptor, item);
        }
        if (ISnapshot.class.isAssignableFrom(descriptor.getType())) {
            return new SnapshotSelectionEditor(parent, context, descriptor, item);
        }
        if (File.class.isAssignableFrom(descriptor.getType())) {
            return new FileOpenDialogEditor(parent, context, descriptor, item);
        }
        if (descriptor.isEnum()) {
            return new EnumComboEditor(parent, context, descriptor, item);
        }
        return new TextEditor(parent, context, descriptor, item);
    }
}

