/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ContentAssistProcessor;
import org.eclipse.dltk.ui.text.completion.ProposalSorterRegistry;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ScriptCompletionProcessor
extends ContentAssistProcessor {
    private IContextInformationValidator fValidator;
    protected final IEditorPart fEditor;

    public ScriptCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        String newValue;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getNatureId());
        if (toolkit == null) {
            return;
        }
        String preferenceQualifier = toolkit.getPreferenceQualifier();
        if (preferenceQualifier == null) {
            return;
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(preferenceQualifier);
        if (node == null) {
            return;
        }
        String value = node.get("org.eclipse.dltk.core.codeComplete.visibilityCheck", null);
        String string = newValue = restrict ? "enabled" : "disabled";
        if (!newValue.equals(value)) {
            node.put("org.eclipse.dltk.core.codeComplete.visibilityCheck", newValue);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = this.createContextInformationValidator();
        }
        return this.fValidator;
    }

    protected IContextInformationValidator createContextInformationValidator() {
        return new ScriptParameterListValidator();
    }

    @Override
    protected List<ICompletionProposal> filterAndSortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ProposalSorterRegistry.getDefault().getCurrentSorter().sortProposals(context, proposals);
        return proposals;
    }

    protected abstract String getNatureId();

    @Deprecated
    protected final CompletionProposalLabelProvider getProposalLabelProvider() {
        return null;
    }

    @Override
    protected final IPreferenceStore getPreferenceStore() {
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit(this.getNatureId());
        if (toolkit != null) {
            return toolkit.getPreferenceStore();
        }
        return DLTKUIPlugin.getDefault().getPreferenceStore();
    }

    @Override
    protected void setContextInformationMode(ContentAssistInvocationContext context) {
        ((ScriptContentAssistInvocationContext)context).setContextInformationMode(true);
    }

    @Override
    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ScriptContentAssistInvocationContext(viewer, offset, this.fEditor, this.getNatureId());
    }

    protected static class ScriptParameterListValidator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private int initialOffset;

        protected ScriptParameterListValidator() {
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.initialOffset = offset;
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(offset - this.initialOffset) < 5;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

