/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.AbstractConnectionInfoComposite;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.ScrapbookEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ConnectionInfoComposite
extends AbstractConnectionInfoComposite
implements SelectionListener,
Listener {
    protected Pattern PROFILE_AND_TYPE = Pattern.compile("(.*)--(.*)\\z");
    private Label _labelName = null;
    Combo _comboProfileName = null;
    private Button _create = null;
    private Label _labelDbName = null;
    Combo _combodbName = null;

    public ConnectionInfoComposite(Composite parent, Listener listener, String profileName, String dbName) {
        this(parent, listener, (ISQLEditorConnectionInfo)new SQLEditorConnectionInfo(null, profileName, dbName), null, false, false, null, false);
    }

    public ConnectionInfoComposite(Composite parent, Listener listener, ISQLEditorConnectionInfo connInfo, Collection supportedDBDefinitionNames, boolean mustConnect, boolean createProfile, GridLayout layout, boolean lazyInit) {
        super(parent, 0, listener, connInfo, supportedDBDefinitionNames, 0x2A | (mustConnect ? 64 : 0) | (lazyInit ? 128 : 0));
        this.createContents();
        if ((this._style & 0x80) == 0) {
            this.init();
        }
    }

    protected Control createContents() {
        GridLayout gridLayout2 = new GridLayout();
        GridData gridData3 = new GridData();
        GridData gridData4 = new GridData();
        GridData gridData5 = new GridData();
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 256;
        this.setLayoutData(gridData6);
        GridLayout layout = new GridLayout();
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 12;
        this.setLayout((Layout)layout);
        this._labelName = new Label((Composite)this, 0);
        this._labelName.setText(Messages.SelectProfileDialog_profile_name);
        gridData4.horizontalAlignment = 3;
        this._labelName.setLayoutData((Object)gridData4);
        Composite compositeName = new Composite((Composite)this, 0);
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        compositeName.setLayoutData((Object)gridData3);
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        compositeName.setLayout((Layout)gridLayout2);
        this.createComboProfileName(compositeName);
        if ((this._style & 1) > 0) {
            this._create = new Button(compositeName, 8);
            this._create.setText(Messages.SelectProfileDialog_create);
            this._create.addListener(13, (Listener)this);
        }
        this._labelDbName = new Label((Composite)this, 0);
        this._labelDbName.setText(Messages.ConnectionInfoGroup_database_name);
        gridData5.horizontalAlignment = 3;
        this._labelDbName.setLayoutData((Object)gridData5);
        this.createComboDbName(this);
        return this;
    }

    @Override
    public void init(String dbVendorName, String initialProfName, String initialDBName) {
        this.setConnectionInfo(dbVendorName, initialProfName, initialDBName);
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        if (this._supportedDBDefinitionNames == null) {
            this._supportedDBDefinitionNames = SQLToolsFacade.getAllAvailableDBDefinitionNames();
        }
        ArrayList<String> rightProfiles = new ArrayList<String>();
        String selectedName = null;
        int i = 0;
        while (i < profiles.length) {
            DatabaseVendorDefinitionId dbVendorId = ProfileUtil.getDatabaseVendorDefinitionId((String)profiles[i].getName());
            if (this._supportedDBDefinitionNames.contains(dbVendorId.toString())) {
                String itemName = this.constructItemName(dbVendorId.toString(), profiles[i].getName());
                rightProfiles.add(itemName);
                if (this._profileName != null && profiles[i].getName().equals(this._profileName)) {
                    selectedName = itemName;
                }
            }
            ++i;
        }
        for (String name : this._supportedDBDefinitionNames) {
            rightProfiles.add(this.constructItemName(name, ""));
        }
        Collections.sort(rightProfiles);
        rightProfiles.add(0, new String(""));
        this._comboProfileName.setItems(rightProfiles.toArray(new String[0]));
        if (selectedName == null) {
            if (this._dbVendorId != null) {
                selectedName = this.constructItemName(this._dbVendorId.toString(), "");
            } else {
                SQLDevToolsConfiguration defaultConfig = SQLToolsFacade.getDefaultConfiguration();
                selectedName = this.constructItemName(defaultConfig.getDatabaseVendorDefinitionId().toString(), "");
            }
        }
        if (selectedName != null) {
            this._comboProfileName.setText(selectedName);
        } else if (this._comboProfileName.getItemCount() > 0) {
            this._comboProfileName.select(0);
        }
        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(this._profileName);
        if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
            this._combodbName.setEnabled(true);
        } else {
            this._combodbName.setEnabled(false);
        }
        this.initDBNames();
        if (this._dbName != null && !this._dbName.equals("")) {
            this._combodbName.setText(this._dbName);
        }
        this.updateFields();
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._comboProfileName) {
            if (this._comboProfileName.getSelectionIndex() != -1) {
                if (this._combodbName != null) {
                    this._combodbName.removeAll();
                    this._dbName = null;
                    this.readControlValues();
                    if (this._profileName != null) {
                        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(this._profileName);
                        if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
                            this._combodbName.setEnabled(true);
                        } else {
                            this._combodbName.setEnabled(false);
                        }
                    } else {
                        this._combodbName.setEnabled(false);
                    }
                }
            } else if (this._combodbName != null) {
                this._combodbName.removeAll();
                this._combodbName.setEnabled(false);
            }
        }
        this.updateFields();
        this.notifyListener();
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    protected void readControlValues() {
        String text = this._comboProfileName.getText();
        if (text != null && !"".equals(text)) {
            Matcher m = this.PROFILE_AND_TYPE.matcher(text);
            if (m.find()) {
                this._dbVendorId = new DatabaseVendorDefinitionId(m.group(1));
                String profileName = m.group(2);
                this._profileName = profileName == null || profileName.equals("") ? null : profileName;
            } else {
                this._dbVendorId = new DatabaseVendorDefinitionId(text);
                this._profileName = null;
            }
        } else {
            this._dbVendorId = DATABASE_VENDOR_DEFINITION_ID;
            this._profileName = null;
        }
        if (this._combodbName != null && this._combodbName.getText() != null && !"".equals(this._combodbName.getText())) {
            this._dbName = this._combodbName.getText();
        }
    }

    @Override
    protected void updateFields() {
        this.readControlValues();
        this._connInfo = new ScrapbookEditorConnectionInfo((ISQLEditorConnectionInfo)new SQLEditorConnectionInfo(this._dbVendorId, this._profileName, this._dbName));
    }

    private void createComboProfileName(Composite composite) {
        GridData gridData5 = new GridData();
        this._comboProfileName = new Combo(composite, 8);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._comboProfileName.setLayoutData((Object)gridData5);
        this._comboProfileName.setVisibleItemCount(30);
        this._comboProfileName.addSelectionListener((SelectionListener)this);
    }

    private void createComboDbName(Composite composite) {
        GridData gridData5 = new GridData();
        this._combodbName = new Combo(composite, 8);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._combodbName.setVisibleItemCount(30);
        this._combodbName.setLayoutData((Object)gridData5);
        if (this._comboProfileName.getSelectionIndex() == -1) {
            this._combodbName.setEnabled(false);
        }
        this._combodbName.addSelectionListener((SelectionListener)this);
    }

    String constructItemName(String type, String name) {
        if (name == null || name.trim().equals("")) {
            return type;
        }
        return String.valueOf(type) + "--" + name;
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this._create) {
            SQLDevToolsUIConfiguration f = SQLToolsUIFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._dbVendorId);
            if (f == null) {
                return;
            }
            IWizard wizard = f.getUIComponentService().getProfileWizard();
            String[] currentNames = this.getCurrentProfileNames();
            WizardDialog dlg = new WizardDialog(this.getShell(), wizard);
            int id = dlg.open();
            if (id != 1) {
                String[] newNames = this.getCurrentProfileNames();
                String newProfile = this.getNewProfileName(currentNames, newNames);
                if (newProfile != null) {
                    this.init(this._dbVendorId.toString(), newProfile, null);
                    this.updateFields();
                }
                this.notifyListener();
            }
        }
    }

    @Override
    public Combo getProfileNamesControl() {
        return this._comboProfileName;
    }

    @Override
    public Combo getDbNamesControl() {
        return this._combodbName;
    }

    @Override
    public Combo getProfileTypeControl() {
        return null;
    }

    @Override
    public Button getCreateButton() {
        return this._create;
    }
}

