/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.io.File;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELMultipageEditorPart;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.dialogs.SaveImageDialog;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SaveImageAction
extends Action
implements IEditorActionDelegate {
    private BPELMultipageEditorPart fEditor;

    public void run(IAction action) {
        SaveImageDialog sid = new SaveImageDialog(Display.getDefault().getActiveShell(), this.fEditor.getEditorInput().getName());
        sid.setHelpAvailable(false);
        if (sid.open() == 1) {
            return;
        }
        String fileName = sid.getFileName();
        File file = new File(fileName);
        if (file.exists() && file.isFile() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SaveImageAction_1, (String)NLS.bind((String)Messages.SaveImageAction_2, (Object[])new Object[]{fileName}))) {
            return;
        }
        try {
            this.saveBPELAsImage((IEditorPart)this.fEditor, fileName, sid.isTransparent());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.fEditor.getEditorSite().getShell(), (String)Messages.SaveImageAction_3, (String)NLS.bind((String)Messages.SaveImageAction_4, (Object[])new Object[]{fileName}));
        }
    }

    private void saveBPELAsImage(IEditorPart editorPart, String fileName, boolean isTransparent) {
        GraphicalViewer viewer = (GraphicalViewer)this.fEditor.getAdapter(GraphicalViewer.class);
        ScalableRootEditPart rootEditPart = (ScalableRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
        Dimension size = figure.getSize();
        Dimension prefSize = figure.getPreferredSize();
        Image image = new Image(null, size.width, size.height);
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        figure.paint((Graphics)graphics);
        Image croppedImage = new Image(null, prefSize.width, prefSize.height + 20);
        GC croppedImageGC = new GC((Drawable)croppedImage);
        SWTGraphics croppedImageGraphics = new SWTGraphics(croppedImageGC);
        croppedImageGraphics.drawImage(image, (size.width - prefSize.width) / 2, 0, prefSize.width, prefSize.height, 0, 0, prefSize.width, prefSize.height);
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = new ImageData[1];
        imgLoader.data[0] = croppedImage.getImageData();
        if (isTransparent) {
            imgLoader.data[0].transparentPixel = imgLoader.data[0].palette.getPixel(new RGB(255, 255, 255));
        }
        int format = 4;
        if (fileName.endsWith(".bmp")) {
            format = 0;
        } else if (fileName.endsWith(".png")) {
            format = 5;
        }
        imgLoader.save(fileName, format);
        gc.dispose();
        image.dispose();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fEditor == null) {
            action.setEnabled(false);
        } else {
            action.setEnabled(this.fEditor.getActiveEditor() instanceof BPELEditor);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor instanceof BPELMultipageEditorPart ? (BPELMultipageEditorPart)targetEditor : null;
    }
}

