/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.extension.model.ExtensionmodelFactory;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IFileChangeListener;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.validator.Builder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class BPELResourceChangeListener
implements IResourceChangeListener {
    protected IResourceDeltaVisitor visitor;
    protected List<IFileChangeListener> listeners = new ArrayList<IFileChangeListener>();

    public void addListener(IFileChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IFileChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(this.getResourceDeltaVisitor());
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
        }
    }

    protected IResourceDeltaVisitor getResourceDeltaVisitor() {
        if (this.visitor == null) {
            this.visitor = new ResourceDeltaVisitor();
        }
        return this.visitor;
    }

    protected static IFile[] getRelatedFiles(IFile bpelFile) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath bpelPath = bpelFile.getFullPath();
        IFile bpelexFile = root.getFile(bpelPath.removeFileExtension().addFileExtension("bpelex"));
        String baseName = bpelPath.removeFileExtension().lastSegment();
        IPath artifactsPath = bpelPath.removeFileExtension().removeLastSegments(1).append(String.valueOf(baseName) + "Artifacts").addFileExtension("wsdl");
        IFile artifactsFile = root.getFile(artifactsPath);
        return new IFile[]{bpelexFile, artifactsFile};
    }

    protected static String getNewRelatedFileName(IFile oldFile, String newBaseName) {
        if ("wsdl".equals(oldFile.getFileExtension())) {
            return String.valueOf(newBaseName) + "Artifacts" + ".wsdl";
        }
        if ("bpelex".equals(oldFile.getFileExtension())) {
            return String.valueOf(newBaseName) + "." + "bpelex";
        }
        return null;
    }

    protected void fileMoved(IFile oldBPELFile, IPath newBPELFilePath) throws CoreException {
        IFile[] relatedFiles = BPELResourceChangeListener.getRelatedFiles(oldBPELFile);
        int i = 0;
        while (i < relatedFiles.length) {
            this.move(relatedFiles[i], newBPELFilePath);
            ++i;
        }
        this.fixBPELExtensionFile(oldBPELFile, newBPELFilePath);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile newBPELFile = root.getFile(newBPELFilePath);
        for (IFileChangeListener listener : this.listeners) {
            listener.moved(oldBPELFile, newBPELFile);
        }
    }

    protected void fixBPELExtensionFile(IFile oldBPELFile, IPath newBPELFilePath) {
        URI bpelURI = URI.createPlatformResourceURI((String)(String.valueOf(newBPELFilePath.toString()) + "#/"));
        IPath newBPELEXFilePath = newBPELFilePath.removeFileExtension().addFileExtension("bpelex");
        URI extensionsURI = URI.createPlatformResourceURI((String)newBPELEXFilePath.toString());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource extensionsResource = resourceSet.getResource(extensionsURI, true);
        try {
            extensionsResource.load(Collections.EMPTY_MAP);
            EList extensionContents = extensionsResource.getContents();
            ExtensionMap extensionMap = ExtensionmodelFactory.eINSTANCE.findExtensionMap("http://org.eclipse.bpel.ui/", extensionContents);
            for (EObject next : extensionMap.keySet()) {
                if (!next.eIsProxy()) continue;
                ((InternalEObject)next).eSetProxyURI(bpelURI);
            }
            extensionsResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException iOException) {}
    }

    protected void move(IFile oldRelatedFile, IPath newBpelPath) throws CoreException {
        if (oldRelatedFile.exists()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile newBpelFile = root.getFile(newBpelPath);
            IContainer folder = newBpelFile.getParent();
            String newBaseName = newBpelFile.getFullPath().removeFileExtension().lastSegment();
            String newName = BPELResourceChangeListener.getNewRelatedFileName(oldRelatedFile, newBaseName);
            IPath newRelatedFilePath = folder.getFullPath().append(newName);
            oldRelatedFile.move(newRelatedFilePath, true, null);
        }
    }

    protected void fileDeleted(IFile oldBPELFile, IProgressMonitor monitor) throws CoreException {
        for (IFileChangeListener listener : this.listeners) {
            listener.deleted(oldBPELFile);
        }
        IFile bpelex = BPELUtil.getBPELEXFile(oldBPELFile);
        try {
            bpelex.delete(true, monitor);
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource target = delta.getResource();
            if (Builder.isBPELFile((IResource)target)) {
                this.handleBPEL(delta);
            }
            return true;
        }

        private void handleBPEL(final IResourceDelta delta) throws CoreException {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFile target = (IFile)delta.getResource();
                    switch (delta.getKind()) {
                        case 2: {
                            int flags = delta.getFlags();
                            if ((flags & 0x2000) != 0) {
                                BPELResourceChangeListener.this.fileMoved(target, delta.getMovedToPath());
                                break;
                            }
                            BPELResourceChangeListener.this.fileDeleted(target, monitor);
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
    }
}

