/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDICreatedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDataReadMemoryInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIMemoryManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMemoryBlock;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataReadMemoryRequest;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;

public class MemoryManager
extends AbstractPDIManager
implements IPDIMemoryManager {
    IPDIMemoryBlock[] EMPTY_MEMORY_BLOCKS = new IPDIMemoryBlock[0];
    Map<TaskSet, List<IPDIMemoryBlock>> blockMap = new Hashtable<TaskSet, List<IPDIMemoryBlock>>();

    public MemoryManager(IPDISession session) {
        super(session, true);
    }

    @Override
    public IPDIMemoryBlock createMemoryBlock(TaskSet qTasks, String address, int units, int wordSize) throws PDIException {
        IPDIDataReadMemoryInfo info = this.createDataReadMemoryInfo(qTasks, address, units, wordSize);
        IPDIMemoryBlock block = this.session.getModelFactory().newMemoryBlock(this.session, qTasks, address, wordSize, true, info);
        List<IPDIMemoryBlock> blockList = this.getMemoryBlockList(qTasks);
        blockList.add(block);
        IPDICreatedEvent event = this.session.getEventFactory().newCreatedEvent(this.session.getEventFactory().newMemoryBlockInfo(this.session, qTasks, new BigInteger[]{block.getStartAddress()}, block));
        this.session.getEventManager().fireEvents(new IPDIEvent[]{event});
        return block;
    }

    @Override
    public IPDIMemoryBlock[] getMemoryBlocks(TaskSet qTasks) throws PDIException {
        List<IPDIMemoryBlock> blockList = this.getMemoryBlockList(qTasks);
        return blockList.toArray(new IPDIMemoryBlock[blockList.size()]);
    }

    @Override
    public void removeAllBlocks(TaskSet qTasks) throws PDIException {
        IPDIMemoryBlock[] blocks = this.getMemoryBlocks(qTasks);
        this.removeBlocks(qTasks, blocks);
    }

    @Override
    public void removeBlocks(TaskSet qTasks, IPDIMemoryBlock[] memoryBlocks) throws PDIException {
        List<IPDIMemoryBlock> blockList = this.blockMap.get(qTasks);
        if (blockList != null) {
            blockList.removeAll(Arrays.asList(memoryBlocks));
        }
    }

    @Override
    public void shutdown() {
        this.blockMap.clear();
    }

    @Override
    public void update(TaskSet qTasks) {
        List<IPDIMemoryBlock> blockList = this.getMemoryBlockList(qTasks);
        IPDIMemoryBlock[] blocks = blockList.toArray(new IPDIMemoryBlock[blockList.size()]);
        ArrayList<IPDIEvent> eventList = new ArrayList<IPDIEvent>(blocks.length);
        int i = 0;
        while (i < blocks.length) {
            if (!blocks[i].isFrozen()) {
                try {
                    this.update(blocks[i], eventList);
                }
                catch (PDIException pDIException) {
                    // empty catch block
                }
            }
            ++i;
        }
        IPDIEvent[] events = eventList.toArray(new IPDIEvent[0]);
        this.session.getEventManager().fireEvents(events);
    }

    @Override
    public BigInteger[] update(IPDIMemoryBlock block, List<IPDIEvent> aList) throws PDIException {
        IPDIMemoryBlock newBlock = this.cloneBlock(block);
        boolean newAddress = !newBlock.getStartAddress().equals(block.getStartAddress());
        BigInteger[] array = this.compareBlocks(block, newBlock);
        block.setDataReadMemoryInfo(newBlock.getDataReadMemoryInfo());
        if (array.length > 0 || newAddress) {
            IPDIChangedEvent event = this.session.getEventFactory().newChangedEvent(this.session.getEventFactory().newMemoryBlockInfo(this.session, block.getTasks(), array, block));
            if (aList != null) {
                aList.add(event);
            } else {
                this.session.getEventManager().fireEvents(new IPDIEvent[]{event});
            }
        }
        return array;
    }

    private IPDIMemoryBlock cloneBlock(IPDIMemoryBlock block) throws PDIException {
        String exp = block.getExpression();
        int wordSize = block.getWordSize();
        IPDIDataReadMemoryInfo info = this.createDataReadMemoryInfo(block.getTasks(), exp, (int)block.getLength(), wordSize);
        return this.session.getModelFactory().newMemoryBlock(this.session, block.getTasks(), exp, wordSize, true, info);
    }

    private BigInteger[] compareBlocks(IPDIMemoryBlock oldBlock, IPDIMemoryBlock newBlock) throws PDIException {
        byte[] oldBytes = oldBlock.getBytes();
        byte[] newBytes = newBlock.getBytes();
        ArrayList<BigInteger> aList = new ArrayList<BigInteger>(newBytes.length);
        BigInteger distance = newBlock.getStartAddress().subtract(oldBlock.getStartAddress());
        int diff = distance.intValue();
        if (Math.abs(diff) < newBytes.length) {
            int i = 0;
            while (i < newBytes.length) {
                if (i + diff < oldBytes.length && i + diff >= 0 && oldBytes[i + diff] != newBytes[i]) {
                    aList.add(newBlock.getStartAddress().add(BigInteger.valueOf(i)));
                }
                ++i;
            }
        }
        return aList.toArray(new BigInteger[aList.size()]);
    }

    private IPDIDataReadMemoryInfo createDataReadMemoryInfo(TaskSet qTasks, String exp, int units, int wordSize) throws PDIException {
        IPDIDataReadMemoryRequest request = this.session.getRequestFactory().getDataReadMemoryRequest(this.session, qTasks, 0L, exp, 0, wordSize, 1, units, null);
        this.session.getEventRequestManager().addEventRequest(request);
        return request.getDataReadMemoryInfo(qTasks);
    }

    private synchronized List<IPDIMemoryBlock> getMemoryBlockList(TaskSet qTasks) {
        List<IPDIMemoryBlock> blockList = this.blockMap.get(qTasks);
        if (blockList == null) {
            blockList = Collections.synchronizedList(new ArrayList());
            this.blockMap.put(qTasks, blockList);
        }
        return blockList;
    }
}

