/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.editpolicies.MarkerEventListenerEditPolicy;
import org.eclipse.papyrus.infra.services.markerlistener.IMarkerEventListener;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.MarkersMonitorService;

public class CssMarkerEventManagerService
implements IMarkerEventListener {
    protected ServicesRegistry servicesRegistry;
    protected Map<String, List<MarkerEventListenerEditPolicy>> eObjectURIToEditPolicies;
    protected MarkersMonitorService monitorService;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        this.eObjectURIToEditPolicies = new HashMap<String, List<MarkerEventListenerEditPolicy>>();
        this.monitorService = (MarkersMonitorService)servicesRegistry.getService(MarkersMonitorService.class);
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
    }

    public void registerEditPolicy(MarkerEventListenerEditPolicy editPolicy) {
        EObject semanticElement;
        Assert.isTrue((boolean)(editPolicy.getHost().getModel() instanceof View));
        if (editPolicy.getHost().getModel() instanceof View && (semanticElement = ((View)editPolicy.getHost().getModel()).getElement()) != null) {
            String semanticElementURI = EcoreUtil.getURI((EObject)semanticElement).toString();
            List<MarkerEventListenerEditPolicy> correspondingGraphicalEditPolicies = this.eObjectURIToEditPolicies.get(semanticElementURI);
            if (correspondingGraphicalEditPolicies == null) {
                correspondingGraphicalEditPolicies = new ArrayList<MarkerEventListenerEditPolicy>();
                correspondingGraphicalEditPolicies.add(editPolicy);
            } else if (!correspondingGraphicalEditPolicies.contains((Object)editPolicy)) {
                correspondingGraphicalEditPolicies.add(editPolicy);
            }
            this.eObjectURIToEditPolicies.put(semanticElementURI, correspondingGraphicalEditPolicies);
            Resource resource = semanticElement.eResource();
            if (resource != null) {
                try {
                    Collection allPapyrusMarkers = this.monitorService.getMarkers(resource, "org.eclipse.papyrus.modelmarker", true);
                    ArrayList<IPapyrusMarker> listOfMarkersForSemanticElement = new ArrayList<IPapyrusMarker>();
                    for (IPapyrusMarker next : allPapyrusMarkers) {
                        URI cddSemanticElementURI = CssMarkerEventManagerService.getURI(next);
                        if (cddSemanticElementURI == null) {
                            return;
                        }
                        if (!cddSemanticElementURI.toString().equals(semanticElementURI)) continue;
                        listOfMarkersForSemanticElement.add(next);
                    }
                    IPapyrusMarker[] markersForSemanticElement = listOfMarkersForSemanticElement.toArray(new IPapyrusMarker[listOfMarkersForSemanticElement.size()]);
                    editPolicy.notifyMarkerChange(markersForSemanticElement, 1);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void unregisterEditPolicy(MarkerEventListenerEditPolicy editPolicy) {
        String semanticElementURI;
        List<MarkerEventListenerEditPolicy> correspondingGraphicalEditParts;
        EObject semanticElement;
        Assert.isTrue((boolean)(editPolicy.getHost().getModel() instanceof View));
        if (editPolicy.getHost().getModel() instanceof View && (semanticElement = ((View)editPolicy.getHost().getModel()).getElement()) != null && (correspondingGraphicalEditParts = this.eObjectURIToEditPolicies.get(semanticElementURI = EcoreUtil.getURI((EObject)semanticElement).toString())) != null) {
            correspondingGraphicalEditParts.remove((Object)editPolicy);
            if (correspondingGraphicalEditParts.isEmpty()) {
                this.eObjectURIToEditPolicies.remove(semanticElementURI);
            } else {
                this.eObjectURIToEditPolicies.put(semanticElementURI, correspondingGraphicalEditParts);
            }
        }
    }

    public void notifyMarkerChange(EObject semanticElement, IPapyrusMarker marker, int markerState) {
        String semanticElementURI;
        List<MarkerEventListenerEditPolicy> correspondingGraphicalEditParts;
        if (semanticElement != null && (correspondingGraphicalEditParts = this.eObjectURIToEditPolicies.get(semanticElementURI = EcoreUtil.getURI((EObject)semanticElement).toString())) != null) {
            for (MarkerEventListenerEditPolicy editPart : correspondingGraphicalEditParts) {
                editPart.notifyMarkerChange(marker, markerState);
            }
        }
    }

    @Deprecated
    public static EObject getEObjectOfMarker(IPapyrusMarker marker) {
        assert (false) : "the getEObjectOfMarker(IPapyrusMarker, ResourceSet) API should be used";
        URI uriOfMarker = CssMarkerEventManagerService.getURI(marker);
        if (uriOfMarker != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Activator.log.warn("Created a new resourceSet to load a marker's target object in " + Activator.log.getCallerMethod());
            return CssMarkerEventManagerService.getEObjectOfMarker(marker, (ResourceSet)resourceSet);
        }
        return null;
    }

    public static EObject getEObjectOfMarker(IPapyrusMarker marker, ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new NullPointerException("resourceSet");
        }
        URI uriOfMarker = CssMarkerEventManagerService.getURI(marker);
        if (uriOfMarker != null) {
            try {
                return resourceSet.getEObject(uriOfMarker, true);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    public static URI getURI(IPapyrusMarker marker) {
        String uriOfMarkerStr = marker.getAttribute("uri", null);
        if (uriOfMarkerStr != null) {
            return URI.createURI((String)uriOfMarkerStr);
        }
        return null;
    }

    public boolean isNotifiedOnInitialMarkerCheck() {
        return false;
    }
}

