/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import com.ibm.icu.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CLineBreakpoint
extends AbstractLineBreakpoint {
    public CLineBreakpoint() {
    }

    public CLineBreakpoint(IResource resource, Map<String, Object> attributes, boolean add) throws CoreException {
        super(resource, attributes, add);
    }

    @Override
    public String getMarkerType() {
        return "org.eclipse.cdt.debug.core.cLineBreakpointMarker";
    }

    @Override
    protected String getMarkerMessage() throws CoreException {
        IMarker marker = this.getMarker();
        int bp_line = 0;
        int bp_request_line = 0;
        String bp_file = null;
        String bp_reqest_file = null;
        if (marker != null) {
            bp_line = marker.getAttribute("lineNumber", -1);
            bp_request_line = marker.getAttribute("requestedLine", -1);
            bp_file = marker.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
            bp_reqest_file = marker.getAttribute("requestedSourceHandle", null);
        }
        if (bp_line != bp_request_line || bp_file == null && bp_reqest_file != null || bp_file != null && !bp_file.equals(bp_reqest_file)) {
            return MessageFormat.format((String)BreakpointMessages.getString("CLineBreakpoint.1"), (Object[])new String[]{CDebugUtils.getBreakpointText(this, false)});
        }
        return MessageFormat.format((String)BreakpointMessages.getString("CLineBreakpoint.0"), (Object[])new String[]{CDebugUtils.getBreakpointText(this, false)});
    }
}

