/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.pmf.emf.EMFDataModelManager;
import org.eclipse.pmf.emf.EMFType;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.Authentication;
import org.eclipse.pmf.pim.Command;
import org.eclipse.pmf.pim.DataAssocication;
import org.eclipse.pmf.pim.DataCollection;
import org.eclipse.pmf.pim.DataConverter;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataFormFolder;
import org.eclipse.pmf.pim.DataFormSelector;
import org.eclipse.pmf.pim.DataInheritance;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.Library;
import org.eclipse.pmf.pim.PMFFactory;
import org.eclipse.pmf.pim.PMFPackage;
import org.eclipse.pmf.pim.SystemAction;
import org.eclipse.pmf.pim.Validator;
import org.eclipse.pmf.pim.ViewProfile;
import org.eclipse.pmf.pim.Wizard;
import org.eclipse.pmf.pim.data.DataModelManager;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.pmf.pim.exception.PMFException;
import org.eclipse.pmf.pim.impl.LibraryImpl;
import org.eclipse.pmf.pim.impl.TypeToDataFormFolderEntryMapImpl;
import org.eclipse.pmf.pim.ui.Container;
import org.eclipse.pmf.pim.ui.Image;
import org.eclipse.pmf.pim.util.PMFUtil;
import org.eclipse.pmf.pim.util.UnmodifiableEMap;

public class ApplicationImpl
extends LibraryImpl
implements Application {
    private int V;
    private int preCount;
    private int[] low;
    private boolean[] visited;
    private Set<Integer>[] graph;
    private Map<Integer, String> dataForms = new HashMap<Integer, String>();
    private List<List<Integer>> sccComp;
    private Stack<Integer> stack;
    protected Container main;
    protected EList<DataModelManager> dataModelManagers;
    protected EList<Library> libraries;
    protected EList<ViewProfile> allViewProfiles;
    protected EList<SystemAction> allSystemActions;
    protected EList<Command> allCommands;
    protected EList<DataConverter> allConverters;
    protected EList<Validator> allValidators;
    protected EList<DataType> allTypes;
    protected EList<Image> allImages;
    protected Authentication authentication;
    protected Validator mandatoryField;
    protected EList<Wizard> wizards;
    protected EMap<DataType, DataFormFolder> allDataFormFolders;
    private EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.isTouch()) {
                return;
            }
            Object feature = notification.getFeature();
            if (PMFPackage.eINSTANCE.getLibrary_Commands() == feature) {
                ApplicationImpl.this.allCommands = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_Converters() == feature) {
                ApplicationImpl.this.allConverters = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_SystemActions() == feature) {
                ApplicationImpl.this.allSystemActions = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_Types() == feature) {
                ApplicationImpl.this.allTypes = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_Validators() == feature) {
                ApplicationImpl.this.allValidators = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_ViewProfiles() == feature) {
                ApplicationImpl.this.allViewProfiles = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_DataFormFolders() == feature) {
                ApplicationImpl.this.allDataFormFolders = null;
            } else if (PMFPackage.eINSTANCE.getLibrary_Images() == feature) {
                ApplicationImpl.this.allImages = null;
            }
        }
    };

    protected ApplicationImpl() {
        this.eAdapters().add((Object)this.adapter);
    }

    @Override
    protected EClass eStaticClass() {
        return PMFPackage.Literals.APPLICATION;
    }

    @Override
    public Container getMain() {
        return this.main;
    }

    public NotificationChain basicSetMain(Container newMain, NotificationChain msgs) {
        Container oldMain = this.main;
        this.main = newMain;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldMain, (Object)newMain);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setMain(Container newMain) {
        if (newMain != this.main) {
            NotificationChain msgs = null;
            if (this.main != null) {
                msgs = ((InternalEObject)this.main).eInverseRemove((InternalEObject)this, -13, null, msgs);
            }
            if (newMain != null) {
                msgs = ((InternalEObject)newMain).eInverseAdd((InternalEObject)this, -13, null, msgs);
            }
            if ((msgs = this.basicSetMain(newMain, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)newMain, (Object)newMain));
        }
    }

    @Override
    public EList<DataModelManager> getDataModelManagers() {
        if (this.dataModelManagers == null) {
            this.dataModelManagers = new EObjectContainmentEList(DataModelManager.class, (InternalEObject)this, 13);
        }
        return this.dataModelManagers;
    }

    @Override
    public EList<Library> getLibraries() {
        if (this.libraries == null) {
            this.libraries = new EObjectResolvingEList<Library>(Library.class, (InternalEObject)this, 14){
                private static final long serialVersionUID = 8927590077852388681L;

                protected void didChange() {
                    super.didChange();
                    ApplicationImpl.this.resetGlobalLists();
                }

                protected void didAdd(int index, Library newObject) {
                    super.didAdd(index, (Object)newObject);
                    newObject.eAdapters().add((Object)ApplicationImpl.this.adapter);
                }

                protected Library doRemove(int index) {
                    Library library = (Library)this.basicGet(index);
                    if (ApplicationImpl.this.hasReferenceUsage(library)) {
                        throw new PMFException("The library can not be removed because there's one or more object(s) had been used by current application.");
                    }
                    return (Library)super.doRemove(index);
                }

                protected void didRemove(int index, Library oldObject) {
                    super.didRemove(index, (Object)oldObject);
                    oldObject.eAdapters().remove((Object)ApplicationImpl.this.adapter);
                }
            };
        }
        return this.libraries;
    }

    protected boolean hasReferenceUsage(Library library) {
        if (library == null) {
            return false;
        }
        EList<Command> commands = library.getCommands();
        for (Command command : commands) {
            Collection usageSettings = EcoreUtil.UsageCrossReferencer.find((EObject)command, (EObject)this);
            for (EStructuralFeature.Setting setting : usageSettings) {
                EObject eObject = setting.getEObject();
                if (!this.isChildOfCurrentApplication(eObject)) continue;
                EStructuralFeature feature = setting.getEStructuralFeature();
                if (PMFPackage.eINSTANCE.getApplication_AllCommands() == feature) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isChildOfCurrentApplication(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        if (eObject == this) {
            return true;
        }
        return this.isChildOfCurrentApplication(eObject.eContainer());
    }

    private void resetGlobalLists() {
        this.allViewProfiles = null;
        this.allCommands = null;
        this.allConverters = null;
        this.allSystemActions = null;
        this.allTypes = null;
        this.allValidators = null;
        this.allViewProfiles = null;
        this.allDataFormFolders = null;
        this.allImages = null;
    }

    @Override
    public EList<ViewProfile> getAllViewProfiles() {
        if (this.allViewProfiles == null) {
            this.allViewProfiles = new EObjectResolvingEList(ViewProfile.class, (InternalEObject)this, 15);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allViewProfiles.addAll(library.getViewProfiles());
            }
            this.allViewProfiles.addAll(this.getViewProfiles());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllViewProfiles(), this.allViewProfiles.size(), this.allViewProfiles.toArray());
    }

    @Override
    public EList<SystemAction> getAllSystemActions() {
        if (this.allSystemActions == null) {
            this.allSystemActions = new EObjectResolvingEList(SystemAction.class, (InternalEObject)this, 16);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allSystemActions.addAll(library.getSystemActions());
            }
            this.allSystemActions.addAll(this.getSystemActions());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllSystemActions(), this.allSystemActions.size(), this.allSystemActions.toArray());
    }

    @Override
    public EList<Command> getAllCommands() {
        if (this.allCommands == null) {
            this.allCommands = new EObjectResolvingEList(Command.class, (InternalEObject)this, 17);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allCommands.addAll(library.getCommands());
            }
            this.allCommands.addAll(this.getCommands());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllCommands(), this.allCommands.size(), this.allCommands.toArray());
    }

    @Override
    public EList<DataConverter> getAllConverters() {
        if (this.allConverters == null) {
            this.allConverters = new EObjectResolvingEList(DataConverter.class, (InternalEObject)this, 18);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allConverters.addAll(library.getConverters());
            }
            this.allConverters.addAll(this.getConverters());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllConverters(), this.allConverters.size(), this.allConverters.toArray());
    }

    @Override
    public EList<Validator> getAllValidators() {
        if (this.allValidators == null) {
            this.allValidators = new EObjectResolvingEList(Validator.class, (InternalEObject)this, 19);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allValidators.addAll(library.getValidators());
            }
            this.allValidators.addAll(this.getValidators());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllValidators(), this.allValidators.size(), this.allValidators.toArray());
    }

    @Override
    public EList<DataType> getAllTypes() {
        if (this.allTypes == null) {
            this.allTypes = new EObjectResolvingEList(DataType.class, (InternalEObject)this, 20);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allTypes.addAll(library.getTypes());
            }
            this.allTypes.addAll(this.getTypes());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllTypes(), this.allTypes.size(), this.allTypes.toArray());
    }

    @Override
    public EList<Image> getAllImages() {
        if (this.allImages == null) {
            this.allImages = new EObjectResolvingEList(Image.class, (InternalEObject)this, 21);
            EList<Library> libraries = this.getLibraries();
            for (Library library : libraries) {
                this.allImages.addAll(library.getImages());
            }
            this.allImages.addAll(this.getImages());
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getApplication_AllImages(), this.allImages.size(), this.allImages.toArray());
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    public NotificationChain basicSetAuthentication(Authentication newAuthentication, NotificationChain msgs) {
        Authentication oldAuthentication = this.authentication;
        this.authentication = newAuthentication;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldAuthentication, (Object)newAuthentication);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setAuthentication(Authentication newAuthentication) {
        if (newAuthentication != this.authentication) {
            NotificationChain msgs = null;
            if (this.authentication != null) {
                msgs = ((InternalEObject)this.authentication).eInverseRemove((InternalEObject)this, -23, null, msgs);
            }
            if (newAuthentication != null) {
                msgs = ((InternalEObject)newAuthentication).eInverseAdd((InternalEObject)this, -23, null, msgs);
            }
            if ((msgs = this.basicSetAuthentication(newAuthentication, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)newAuthentication, (Object)newAuthentication));
        }
    }

    @Override
    public Validator getMandatoryField() {
        if (this.mandatoryField != null && this.mandatoryField.eIsProxy()) {
            InternalEObject oldMandatoryField = (InternalEObject)this.mandatoryField;
            this.mandatoryField = (Validator)this.eResolveProxy(oldMandatoryField);
            if (this.mandatoryField != oldMandatoryField && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 23, (Object)oldMandatoryField, (Object)this.mandatoryField));
            }
        }
        return this.mandatoryField;
    }

    public Validator basicGetMandatoryField() {
        return this.mandatoryField;
    }

    @Override
    public void setMandatoryField(Validator newMandatoryField) {
        Validator oldMandatoryField = this.mandatoryField;
        this.mandatoryField = newMandatoryField;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldMandatoryField, (Object)this.mandatoryField));
        }
    }

    @Override
    public EList<Wizard> getWizards() {
        if (this.wizards == null) {
            this.wizards = new EObjectContainmentEList(Wizard.class, (InternalEObject)this, 24);
        }
        return this.wizards;
    }

    @Override
    public EMap<DataType, DataFormFolder> getAllDataFormFolders() {
        if (this.allDataFormFolders == null) {
            this.allDataFormFolders = new EcoreEMap(PMFPackage.Literals.TYPE_TO_DATA_FORM_FOLDER_ENTRY_MAP, TypeToDataFormFolderEntryMapImpl.class, (InternalEObject)this, 9);
            for (Library library : this.getLibraries()) {
                this.allDataFormFolders.putAll(library.getDataFormFolders());
            }
            this.allDataFormFolders.putAll(this.getDataFormFolders());
            this.allDataFormFolders = new UnmodifiableEMap<DataType, DataFormFolder>(PMFPackage.Literals.TYPE_TO_DATA_FORM_FOLDER_ENTRY_MAP, TypeToDataFormFolderEntryMapImpl.class, this.allDataFormFolders, (InternalEObject)this, (EStructuralFeature)PMFPackage.eINSTANCE.getLibrary_DataFormFolders());
        }
        return this.allDataFormFolders;
    }

    @Override
    public void importModel(Resource resource) {
        DataFormFolder folder;
        EMFDataModelManager dataModelManager = PMFUtil.dataModelManager(this);
        HashMap<DataType, DataFormFolder> mapCollector = new HashMap<DataType, DataFormFolder>();
        EMap<DataType, DataFormFolder> map = this.getDataFormFolders();
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            DataType type;
            EObject object = (EObject)iterator.next();
            if (object instanceof GenClassifier) {
                GenClassifier genClassifier = (GenClassifier)object;
                EMFType type2 = (EMFType)dataModelManager.getDataModelType((EObject)genClassifier.getEcoreClassifier());
                if (type2 == null) continue;
                type2.updateGenmodel(genClassifier);
                continue;
            }
            if (object instanceof EClassifier && (type = dataModelManager.getDataModelType(object)) != null) continue;
        }
        iterator = dataModelManager.eAllContents();
        while (iterator.hasNext()) {
            EObject type = (EObject)iterator.next();
            if (!(type instanceof EMFType) || ((EMFType)type).isPrimitive()) continue;
            folder = (DataFormFolder)map.get((Object)type);
            boolean isNewFolder = false;
            if (folder == null) {
                folder = PMFFactory.eINSTANCE.createDataFormFolder();
                map.put((Object)((DataType)type), (Object)folder);
                mapCollector.put((DataType)type, folder);
                isNewFolder = true;
            }
            ElementalDataForm dataForm = PMFFactory.eINSTANCE.createElementalDataForm();
            dataForm.setDataContextType((DataType)type);
            folder.getDataForms().add((Object)dataForm);
            if (isNewFolder) {
                folder.setDefaultDataForm(dataForm);
            }
            dataForm.setName(((EMFType)type).getName());
        }
        for (DataType dataType : mapCollector.keySet()) {
            folder = (DataFormFolder)mapCollector.get(dataType);
            for (DataForm dataForm : folder.getDataForms()) {
                if (!(dataForm instanceof ElementalDataForm)) continue;
                dataModelManager.loadFor((ElementalDataForm)dataForm, dataType);
                this.getTypes().add((Object)dataType);
            }
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 12: {
                return this.basicSetMain(null, msgs);
            }
            case 13: {
                return ((InternalEList)this.getDataModelManagers()).basicRemove((Object)otherEnd, msgs);
            }
            case 22: {
                return this.basicSetAuthentication(null, msgs);
            }
            case 24: {
                return ((InternalEList)this.getWizards()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 12: {
                return this.getMain();
            }
            case 13: {
                return this.getDataModelManagers();
            }
            case 14: {
                return this.getLibraries();
            }
            case 15: {
                return this.getAllViewProfiles();
            }
            case 16: {
                return this.getAllSystemActions();
            }
            case 17: {
                return this.getAllCommands();
            }
            case 18: {
                return this.getAllConverters();
            }
            case 19: {
                return this.getAllValidators();
            }
            case 20: {
                return this.getAllTypes();
            }
            case 21: {
                return this.getAllImages();
            }
            case 22: {
                return this.getAuthentication();
            }
            case 23: {
                if (resolve) {
                    return this.getMandatoryField();
                }
                return this.basicGetMandatoryField();
            }
            case 24: {
                return this.getWizards();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setMain((Container)newValue);
                return;
            }
            case 13: {
                this.getDataModelManagers().clear();
                this.getDataModelManagers().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getLibraries().clear();
                this.getLibraries().addAll((Collection)newValue);
                return;
            }
            case 22: {
                this.setAuthentication((Authentication)newValue);
                return;
            }
            case 23: {
                this.setMandatoryField((Validator)newValue);
                return;
            }
            case 24: {
                this.getWizards().clear();
                this.getWizards().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setMain(null);
                return;
            }
            case 13: {
                this.getDataModelManagers().clear();
                return;
            }
            case 14: {
                this.getLibraries().clear();
                return;
            }
            case 22: {
                this.setAuthentication(null);
                return;
            }
            case 23: {
                this.setMandatoryField(null);
                return;
            }
            case 24: {
                this.getWizards().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 12: {
                return this.main != null;
            }
            case 13: {
                return this.dataModelManagers != null && !this.dataModelManagers.isEmpty();
            }
            case 14: {
                return this.libraries != null && !this.libraries.isEmpty();
            }
            case 15: {
                return this.allViewProfiles != null && !this.allViewProfiles.isEmpty();
            }
            case 16: {
                return this.allSystemActions != null && !this.allSystemActions.isEmpty();
            }
            case 17: {
                return this.allCommands != null && !this.allCommands.isEmpty();
            }
            case 18: {
                return this.allConverters != null && !this.allConverters.isEmpty();
            }
            case 19: {
                return this.allValidators != null && !this.allValidators.isEmpty();
            }
            case 20: {
                return this.allTypes != null && !this.allTypes.isEmpty();
            }
            case 21: {
                return this.allImages != null && !this.allImages.isEmpty();
            }
            case 22: {
                return this.authentication != null;
            }
            case 23: {
                return this.mandatoryField != null;
            }
            case 24: {
                return this.wizards != null && !this.wizards.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean validate(DiagnosticChain diagnostic, Map<Object, Object> context) {
        boolean valid = true;
        this.initGraph(this);
        List<List<Integer>> scComponents = this.getSCComponents(this.graph);
        StringBuffer stringBuffer = new StringBuffer();
        for (List<Integer> list : scComponents) {
            ArrayList l = (ArrayList)list;
            if (l.size() <= 1) continue;
            stringBuffer.append("[");
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String dataForm = this.dataForms.get(i);
                stringBuffer.append(String.valueOf(dataForm) + " ");
                if (i >= l.size()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("] ");
        }
        if (diagnostic != null && this.sccComp.size() > 0) {
            valid = false;
            diagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.pmf.pim", 20, "Cycle referenced dataforms: " + stringBuffer.toString(), new Object[]{this}));
        }
        return valid;
    }

    public List<List<Integer>> getSCComponents(Set<Integer>[] graph) {
        this.V = graph.length;
        this.graph = graph;
        this.low = new int[this.V];
        this.visited = new boolean[this.V];
        this.stack = new Stack();
        this.sccComp = new ArrayList<List<Integer>>();
        int v = 0;
        while (v < this.V) {
            if (!this.visited[v]) {
                this.dfs(v);
            }
            ++v;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.sccComp.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object list = objectArray[n2];
            ArrayList l = (ArrayList)list;
            if (l.size() > 1) {
                Object[] objectArray2 = l.toArray();
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object i = objectArray2[n4];
                    int j = (Integer)i;
                    String dataForm = this.dataForms.get(i);
                    stringBuffer.append(String.valueOf(dataForm) + " ");
                    ++n4;
                }
                stringBuffer.append(";");
            }
            ++n2;
        }
        return this.sccComp;
    }

    public void dfs(int v) {
        int w;
        ++this.preCount;
        this.visited[v] = true;
        this.stack.push(v);
        int min = this.low[v];
        for (int w2 : this.graph[v]) {
            if (!this.visited[w2]) {
                this.dfs(w2);
            }
            if (this.low[w2] >= min) continue;
            min = this.low[w2];
        }
        if (min < this.low[v]) {
            this.low[v] = min;
            return;
        }
        ArrayList<Integer> component = new ArrayList<Integer>();
        do {
            w = this.stack.pop();
            component.add(w);
            this.low[w] = this.V;
        } while (w != v);
        this.sccComp.add(component);
    }

    public void initGraph(Application application) {
        int index = 0;
        for (Map.Entry dataFormFolder : application.getDataFormFolders()) {
            for (DataForm dataForm : ((DataFormFolder)dataFormFolder.getValue()).getDataForms()) {
                this.dataForms.put(index, dataForm.getName());
                ++index;
            }
        }
        this.graph = new Set[index];
        int i = 0;
        while (i < index) {
            this.graph[i] = new HashSet<Integer>();
            ++i;
        }
        for (Map.Entry dataFormFolder : application.getDataFormFolders()) {
            ArrayList<ElementalDataForm> elementalDataForms = new ArrayList<ElementalDataForm>();
            EList<DataForm> dataForms = ((DataFormFolder)dataFormFolder.getValue()).getDataForms();
            for (DataForm dataForm : dataForms) {
                if (dataForm instanceof ElementalDataForm) {
                    elementalDataForms.add((ElementalDataForm)dataForm);
                    continue;
                }
                if (!(dataForm instanceof DataFormSelector)) continue;
                elementalDataForms.addAll((Collection<ElementalDataForm>)((DataFormSelector)dataForm).getElements());
            }
            for (DataForm dataForm : elementalDataForms) {
                int dataFormIndex = this.getDataFormIndex(dataForm);
                EList<DataItem> dataItems = dataForm.getChildren();
                if (dataItems == null || dataItems.isEmpty()) continue;
                for (DataItem dataItem : dataItems) {
                    switch (dataItem.eClass().getClassifierID()) {
                        case 6: {
                            DataCollection dataCollection = (DataCollection)dataItem;
                            if (dataCollection.getDetail() == null) break;
                            int dataCollectionIndex = this.getDataFormIndex(dataCollection.getDetail());
                            this.graph[dataFormIndex].add(dataCollectionIndex);
                            break;
                        }
                        case 27: {
                            DataAssocication dataAssociation = (DataAssocication)dataItem;
                            if (dataAssociation.getDataForm() == null) break;
                            int dataAssociationIndex = this.getDataFormIndex(dataAssociation.getDataForm());
                            this.graph[dataFormIndex].add(dataAssociationIndex);
                            break;
                        }
                        case 26: {
                            DataInheritance dataInheritance = (DataInheritance)dataItem;
                            if (dataInheritance.getDataForm() == null) break;
                            int dataInheritanceIndex = this.getDataFormIndex(dataInheritance.getDataForm());
                            this.graph[dataFormIndex].add(dataInheritanceIndex);
                        }
                    }
                }
            }
        }
    }

    public Integer getDataFormIndex(DataForm dataForm) {
        int index = 0;
        for (int formIndex : this.dataForms.keySet()) {
            if (!this.dataForms.get(formIndex).equals(dataForm.getName())) continue;
            index = formIndex;
            break;
        }
        return index;
    }
}

