/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.util.List;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndexField;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBIndexField
extends DBSchemaElement
implements InternalDBIndexField {
    private static final long serialVersionUID = 1L;
    private IDBIndex index;
    private IDBField field;
    private int position;

    public DBIndexField(IDBIndex index, IDBField field, int position) {
        super(field.getName());
        this.index = index;
        this.field = field;
        this.position = position;
    }

    protected DBIndexField() {
    }

    @Override
    public IDBIndexField getWrapper() {
        return (IDBIndexField)super.getWrapper();
    }

    @Override
    public IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return IDBSchemaElement.SchemaElementType.INDEX_FIELD;
    }

    @Override
    public IDBIndex getIndex() {
        return this.index;
    }

    @Override
    public IDBIndex getParent() {
        return this.getIndex();
    }

    @Override
    public IDBField getField() {
        return this.field;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.assertUnlocked();
        this.position = position;
    }

    @Override
    public IDBSchema getSchema() {
        return this.field.getSchema();
    }

    @Override
    public String getFullName() {
        return this.field.getFullName();
    }

    @Override
    public void remove() {
        ((InternalDBIndex)this.index).removeIndexField(this);
    }

    @Override
    protected void collectElements(List<IDBSchemaElement> elements) {
    }

    @Override
    protected void doAccept(IDBSchemaVisitor visitor) {
        visitor.visit(this);
    }

    private void assertUnlocked() {
        ((InternalDBSchema)this.index.getTable().getSchema()).assertUnlocked();
    }
}

