/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

public class Event {
    public static final int UNDEFINED = 0;
    protected Object m_source = null;
    protected int m_type = 0;

    public Event(Object source) {
        this(source, 0);
    }

    public Event(Object source, int type) {
        this.m_source = source;
        this.m_type = type;
    }

    public void dispose() {
        this.m_source = null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("[");
        if (this.m_type != 0) {
            result.append(this.typeToString(this.m_type));
        }
        result.append("]");
        return result.toString();
    }

    public String typeToString(int type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "UNDEFINED";
                break;
            }
            default: {
                result = "OTHER(" + type + ")";
            }
        }
        return result;
    }

    public Object getSource() {
        return this.m_source;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isType(int type) {
        return this.m_type == type;
    }
}

