/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.proposal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public abstract class AbstractNlsTextCompletionComputer
implements IJavaCompletionProposalComputer {
    private static final Pattern PATTERN = Pattern.compile("([A-Za-z0-9\\_\\-]*)\\.get\\(\\\"([a-zA-Z0-9\\_\\-]*)");

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        return this.computeProposals(javaContext);
    }

    protected List<ICompletionProposal> computeProposals(JavaContentAssistInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        int offset = context.getInvocationOffset();
        IDocument doc = context.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return proposals;
        }
        try {
            IRegion lineInfo = doc.getLineInformationOfOffset(offset);
            String linePart = doc.get(lineInfo.getOffset(), lineInfo.getLength());
            Matcher m = PATTERN.matcher(linePart);
            int cursorPosInLine = offset - lineInfo.getOffset();
            int matchingStart = -1;
            String refType = null;
            while (m.find()) {
                int match = m.start(2);
                if (match > cursorPosInLine || match <= matchingStart) continue;
                matchingStart = match;
                refType = m.group(1);
            }
            if (matchingStart >= 0 && refType != null) {
                INlsProject nlsProject;
                String prefix = linePart.substring(matchingStart, offset - lineInfo.getOffset());
                IType contextType = AbstractNlsTextCompletionComputer.findContextType(context.getCompilationUnit(), offset);
                if (S2eUtils.exists((IJavaElement)contextType) && (nlsProject = NlsCore.getNlsWorkspace().getNlsProject(contextType, contextType)) != null) {
                    this.collectProposals(proposals, nlsProject, prefix, offset);
                }
            }
        }
        catch (Exception e) {
            SdkLog.warning((String)"could not compute nls proposals.", (Object[])new Object[]{e});
        }
        return proposals;
    }

    protected abstract void collectProposals(List<ICompletionProposal> var1, INlsProject var2, String var3, int var4);

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return "";
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    private static IType findContextType(ICompilationUnit icu, int offset) throws JavaModelException {
        IJavaElement element = icu.getElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 7) {
            return (IType)element;
        }
        return (IType)element.getAncestor(7);
    }
}

