/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ClassInstanceCreation
extends Expression {
    private final Expression className;
    private final CallArgumentsList ctorParams;
    private final AnonymousClassDeclaration anonymousClassDeclaration;

    public ClassInstanceCreation(int start, int end, Expression className, CallArgumentsList ctorParams) {
        this(start, end, className, ctorParams, null);
    }

    public ClassInstanceCreation(int start, int end, Expression className, CallArgumentsList ctorParams, AnonymousClassDeclaration anonymousClass) {
        super(start, end);
        assert (className != null && ctorParams != null);
        this.className = className;
        this.ctorParams = ctorParams;
        this.anonymousClassDeclaration = anonymousClass;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            if (this.className != null) {
                this.className.traverse(visitor);
            }
            this.ctorParams.traverse(visitor);
            if (this.anonymousClassDeclaration != null) {
                this.anonymousClassDeclaration.traverse(visitor);
            }
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 13;
    }

    public Expression getClassName() {
        return this.className;
    }

    public CallArgumentsList getCtorParams() {
        return this.ctorParams;
    }

    public AnonymousClassDeclaration getAnonymousClassDeclaration() {
        return this.anonymousClassDeclaration;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

