/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.FunctionArgumentSeparatorToken;
import org.eclipse.jubula.client.core.utils.FunctionToken;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.LiteralToken;
import org.eclipse.jubula.client.core.utils.SimpleStringConverter;
import org.eclipse.jubula.client.core.utils.SimpleValueToken;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class TestDataBP {
    private static final String CTDS = "getCentralTestDataSetValue";

    private TestDataBP() {
    }

    public static boolean isValueSetParam(ICapPO cap, IParamDescriptionPO paramDesc, String paramValue) {
        Action action = CapBP.getAction(cap);
        Param param = action.findParam(paramDesc.getUniqueId());
        return param.findValueSetElementByValue(paramValue) != null;
    }

    public static String getTestData(IParamNodePO paramNode, ITDManager testDataManager, IParamDescriptionPO paramDesc, int dataSetNum) {
        IParamDescriptionPO dataCubeParam;
        IParameterInterfacePO refDataCube = paramNode.getReferencedDataCube();
        int column = testDataManager.findColumnForParam(paramDesc.getUniqueId());
        if (refDataCube != null && (dataCubeParam = refDataCube.getParameterForName(paramDesc.getName())) != null) {
            column = testDataManager.findColumnForParam(dataCubeParam.getUniqueId());
        }
        IDataSetPO dataSet = testDataManager.getDataSet(dataSetNum);
        if (column != -1 && column < dataSet.getColumnCount()) {
            return dataSet.getValueAt(column);
        }
        return null;
    }

    public static boolean isCTDSReferenced(String ctds, String value) {
        for (String[] res : TestDataBP.getAllCTDSReferences(value)) {
            if (!StringUtils.equals((String)ctds, (String)res[0])) continue;
            return true;
        }
        return false;
    }

    public static List<String[]> getAllCTDSReferences(String value) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        SimpleStringConverter conv = new SimpleStringConverter(value);
        TestDataBP.addAllCTDSRefsNotGetCTDS(res, conv.getTokens().toArray(new IParamValueToken[0]));
        ArrayList<String[]> realRes = new ArrayList<String[]>(res.size());
        Set<String> usedNames = TestDataCubeBP.getSetOfUsedNames(GeneralStorage.getInstance().getProject().getTestDataCubeCont());
        for (String[] arr : res) {
            if (!usedNames.contains(arr[0])) continue;
            realRes.add(arr);
        }
        return res;
    }

    private static void addAllCTDSRefsNotGetCTDS(List<String[]> res, IParamValueToken[] tokens) {
        int ind = 0;
        while (ind < tokens.length) {
            FunctionToken funct;
            IParamValueToken next;
            if (!((next = tokens[ind++]) instanceof FunctionToken) || !StringUtils.equals((String)(funct = (FunctionToken)next).getFunctionName(), (String)CTDS)) continue;
            TestDataBP.addAllCTDSRefsGetCTDS(res, funct.getArguments());
        }
    }

    private static void addAllCTDSRefsGetCTDS(List<String[]> res, IParamValueToken[] tokens) {
        String[] args = new String[4];
        int parInd = 0;
        int ind = 0;
        StringBuilder curr = new StringBuilder();
        while (ind < tokens.length && parInd < 4) {
            if (tokens[ind] instanceof FunctionArgumentSeparatorToken) {
                args[parInd] = curr == null ? null : curr.toString();
                ++parInd;
                curr = new StringBuilder();
                ++ind;
                continue;
            }
            if (tokens[ind] instanceof FunctionToken) {
                FunctionToken next = (FunctionToken)tokens[ind++];
                curr = null;
                if (StringUtils.equals((String)next.getFunctionName(), (String)CTDS)) {
                    TestDataBP.addAllCTDSRefsGetCTDS(res, next.getArguments());
                } else {
                    TestDataBP.addAllCTDSRefsNotGetCTDS(res, next.getArguments());
                }
                ++ind;
                continue;
            }
            if (curr != null && (tokens[ind] instanceof SimpleValueToken || tokens[ind] instanceof LiteralToken)) {
                try {
                    curr.append(tokens[ind].getExecutionString(null));
                }
                catch (InvalidDataException invalidDataException) {
                    curr = null;
                }
            } else {
                curr = null;
            }
            ++ind;
        }
        if (parInd != 3 || args[0] == null) {
            return;
        }
        if (curr != null) {
            args[3] = curr.toString();
        }
        res.add(args);
    }
}

