/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathContainer
implements IPathEntryContainer {
    public static final IPath CONTAINER_ID = new Path("org.eclipse.cdt.make.core.DISCOVERED_SCANNER_INFO");
    protected final IProject fProject;
    private IPathEntry[] fPathEntries;

    public DiscoveredPathContainer(IProject project) {
        this.fProject = project;
        this.fPathEntries = null;
    }

    public String getDescription() {
        return MakeMessages.getString("DiscoveredContainer.description");
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }

    public IPathEntry[] getPathEntries() {
        if (this.fPathEntries == null) {
            try {
                this.fPathEntries = this.computeNewPathEntries();
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                return new IPathEntry[0];
            }
        }
        return this.fPathEntries;
    }

    private IPathEntry[] computeNewPathEntries() throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
        IPath[] includes = info.getIncludePaths();
        Map<String, String> syms = info.getSymbols();
        ArrayList<Object> entries = new ArrayList<Object>(includes.length + syms.size());
        IPath[] iPathArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            IPath inc = iPathArray[n2];
            entries.add(CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)inc, (boolean)true));
            ++n2;
        }
        Set<Map.Entry<String, String>> entrySet = syms.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)entry.getKey(), (String)entry.getValue()));
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }
}

