/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.tickupdate.command;

import net.sourceforge.nattable.command.AbstractLayerCommandHandler;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.config.IEditableRule;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.edit.EditConfigAttributes;
import net.sourceforge.nattable.edit.command.EditUtils;
import net.sourceforge.nattable.edit.command.UpdateDataCommand;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.tickupdate.ITickUpdateHandler;
import net.sourceforge.nattable.tickupdate.TickUpdateConfigAttributes;
import net.sourceforge.nattable.tickupdate.command.TickUpdateCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TickUpdateCommandHandler
extends AbstractLayerCommandHandler<TickUpdateCommand> {
    private SelectionLayer selectionLayer;

    public TickUpdateCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public boolean doCommand(TickUpdateCommand command) {
        PositionCoordinate[] selectedPositions = this.selectionLayer.getSelectedCells();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        if (selectedPositions.length > 1) {
            ICellEditor lastSelectedCellEditor = EditUtils.lastSelectedCellEditor(this.selectionLayer, configRegistry);
            if (EditUtils.isEditorSame(this.selectionLayer, configRegistry, lastSelectedCellEditor) && EditUtils.allCellsEditable(this.selectionLayer, configRegistry)) {
                PositionCoordinate[] positionCoordinateArray = selectedPositions;
                int n = selectedPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    PositionCoordinate position = positionCoordinateArray[n2];
                    this.updateSingleCell(command, position);
                    ++n2;
                }
            }
        } else {
            this.updateSingleCell(command, this.selectionLayer.getLastSelectedCellPosition());
        }
        return true;
    }

    private void updateSingleCell(TickUpdateCommand command, PositionCoordinate selectedPosition) {
        LayerCell cell = this.selectionLayer.getCellByPosition(selectedPosition.columnPosition, selectedPosition.rowPosition);
        IEditableRule editableRule = command.getConfigRegistry().getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", cell.getConfigLabels().getLabels());
        if (editableRule.isEditable(selectedPosition.columnPosition, selectedPosition.rowPosition)) {
            this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, selectedPosition.columnPosition, selectedPosition.rowPosition, this.getNewCellValue(command, cell)));
        }
    }

    private Object getNewCellValue(TickUpdateCommand command, LayerCell cell) {
        ITickUpdateHandler tickUpdateHandler = command.getConfigRegistry().getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, "EDIT", cell.getConfigLabels().getLabels());
        Object dataValue = cell.getDataValue();
        if (tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(dataValue)) {
            if (command.isIncrement()) {
                return tickUpdateHandler.getIncrementedValue(dataValue);
            }
            return tickUpdateHandler.getDecrementedValue(dataValue);
        }
        return dataValue;
    }

    @Override
    public Class<TickUpdateCommand> getCommandClass() {
        return TickUpdateCommand.class;
    }
}

