/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style.editor;

import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;

public class FontPicker
extends Button {
    private Font selectedFont;
    private FontData[] fontData = new FontData[1];
    private Font displayFont;

    public FontPicker(Composite parent, Font originalFont) {
        super(parent, 0);
        if (originalFont == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(originalFont.getFontData()[0]);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog dialog = new FontDialog(new Shell(Display.getDefault(), 1264));
                dialog.setFontList(FontPicker.this.fontData);
                FontData selected = dialog.open();
                if (selected != null) {
                    FontPicker.this.update(selected);
                    FontPicker.this.pack(true);
                }
            }
        });
    }

    private void update(FontData data) {
        this.fontData[0] = data;
        this.selectedFont = GUIHelper.getFont(data);
        this.setText(String.valueOf(data.getName()) + ", " + data.getHeight() + "pt");
        this.setFont(this.createDisplayFont(data));
        this.setAlignment(0x1000000);
        this.setToolTipText("Click to select font");
    }

    private Font createDisplayFont(FontData data) {
        FontData resizedData = new FontData(data.getName(), 8, data.getStyle());
        this.displayFont = GUIHelper.getFont(resizedData);
        return this.displayFont;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("null");
        }
        this.update(font.getFontData()[0]);
    }

    protected void checkSubclass() {
    }
}

