/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style;

import java.util.List;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.style.ConfigAttribute;
import net.sourceforge.nattable.style.IDisplayModeOrdering;
import net.sourceforge.nattable.style.IStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StyleProxy
implements IStyle {
    private final ConfigAttribute<IStyle> styleConfigAttribute;
    private final IConfigRegistry configRegistry;
    private final String targetDisplayMode;
    private final List<String> configLabels;

    public StyleProxy(ConfigAttribute<IStyle> styleConfigAttribute, IConfigRegistry configRegistry, String targetDisplayMode, List<String> configLabels) {
        this.styleConfigAttribute = styleConfigAttribute;
        this.configRegistry = configRegistry;
        this.targetDisplayMode = targetDisplayMode;
        this.configLabels = configLabels;
    }

    @Override
    public <T> T getAttributeValue(ConfigAttribute<T> styleAttribute) {
        T styleAttributeValue = null;
        IDisplayModeOrdering displayModeOrdering = this.configRegistry.getDisplayModeOrdering();
        for (String displayMode : displayModeOrdering.getDisplayModeOrdering(this.targetDisplayMode)) {
            for (String configLabel : this.configLabels) {
                IStyle cellStyle = this.configRegistry.getSpecificConfigAttribute(this.styleConfigAttribute, displayMode, configLabel);
                if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
                return styleAttributeValue;
            }
            IStyle cellStyle = this.configRegistry.getConfigAttribute(this.styleConfigAttribute, displayMode, new String[0]);
            if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
            return styleAttributeValue;
        }
        return null;
    }
}

