/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.event.IStructuralChangeEvent;
import net.sourceforge.nattable.layer.event.RowVisualChangeEvent;
import net.sourceforge.nattable.layer.event.StructuralDiff;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowStructuralChangeEvent
extends RowVisualChangeEvent
implements IStructuralChangeEvent {
    public RowStructuralChangeEvent(ILayer layer, Range ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowStructuralChangeEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        super(layer, rowPositionRanges);
    }

    protected RowStructuralChangeEvent(RowStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        ArrayList<Rectangle> changedPositionRectangles = new ArrayList<Rectangle>();
        int columnCount = this.getLayer().getColumnCount();
        int rowCount = this.getLayer().getRowCount();
        for (Range range : this.getRowPositionRanges()) {
            changedPositionRectangles.add(new Rectangle(0, range.start, columnCount, rowCount - range.start));
        }
        return changedPositionRectangles;
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return false;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        return null;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return true;
    }
}

